/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jetbrick.util.StringUtils;
import jetbrick.util.Validate;

public class ClassLoaderUtils {
    private static final Map<String, String> abbreviationMap = new HashMap<String, String>();

    public static ClassLoader getDefault() {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loader == null && (loader = ClassLoaderUtils.class.getClassLoader()) == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public static Class<?> loadClass(String qualifiedClassName) {
        return ClassLoaderUtils.loadClass(qualifiedClassName, null);
    }

    public static Class<?> loadClass(String qualifiedClassName, ClassLoader loader) {
        try {
            return ClassLoaderUtils.loadClassEx(qualifiedClassName, loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> loadClassEx(String qualifiedClassName) throws ClassNotFoundException {
        return ClassLoaderUtils.loadClassEx(qualifiedClassName, null);
    }

    public static Class<?> loadClassEx(String qualifiedClassName, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader loader;
        Validate.notNull(qualifiedClassName, "qualifiedClassName must be not null", new Object[0]);
        ClassLoader classLoader2 = loader = classLoader == null ? ClassLoaderUtils.getDefault() : classLoader;
        if (abbreviationMap.containsKey(qualifiedClassName)) {
            String className = '[' + abbreviationMap.get(qualifiedClassName);
            return Class.forName(className, false, loader).getComponentType();
        }
        try {
            String className = ClassLoaderUtils.getCanonicalClassName(qualifiedClassName);
            return Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            int ipos;
            if (qualifiedClassName.indexOf(36) == -1 && (ipos = qualifiedClassName.lastIndexOf(46)) > 0) {
                try {
                    String className = qualifiedClassName.substring(0, ipos) + '$' + qualifiedClassName.substring(ipos + 1);
                    className = ClassLoaderUtils.getCanonicalClassName(className);
                    return Class.forName(className, false, loader);
                }
                catch (ClassNotFoundException e2) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(qualifiedClassName);
        }
    }

    public static String getCanonicalClassName(String qualifiedClassName) {
        Validate.notNull(qualifiedClassName, "qualifiedClassName must be not null", new Object[0]);
        String name = StringUtils.deleteWhitespace(qualifiedClassName);
        if (name.endsWith("[]")) {
            StringBuilder sb = new StringBuilder();
            while (name.endsWith("[]")) {
                name = name.substring(0, name.length() - 2);
                sb.append('[');
            }
            String abbreviation = abbreviationMap.get(name);
            if (abbreviation != null) {
                sb.append(abbreviation);
            } else {
                sb.append('L').append(name).append(';');
            }
            name = sb.toString();
        }
        return name;
    }

    public static URL getResource(String name) {
        return ClassLoaderUtils.getResource(name, null);
    }

    public static URL getResource(String name, ClassLoader classLoader) {
        URL url;
        URL url2;
        Validate.notNull(name, "resourceName must be not null", new Object[0]);
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (classLoader != null && (url2 = classLoader.getResource(name)) != null) {
            return url2;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null && loader != classLoader && (url = loader.getResource(name)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(name);
    }

    public static InputStream getResourceAsStream(String name) throws IOException {
        return ClassLoaderUtils.getResourceAsStream(name, null);
    }

    public static InputStream getResourceAsStream(String name, ClassLoader classLoader) throws IOException {
        URL url = ClassLoaderUtils.getResource(name, classLoader);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getClassAsStream(Class<?> clazz) throws IOException {
        return ClassLoaderUtils.getResourceAsStream(ClassLoaderUtils.getClassFileName(clazz), clazz.getClassLoader());
    }

    public static InputStream getClassAsStream(String qualifiedClassName) throws IOException {
        return ClassLoaderUtils.getResourceAsStream(ClassLoaderUtils.getClassFileName(qualifiedClassName));
    }

    public static String getClassFileName(Class<?> clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return ClassLoaderUtils.getClassFileName(clazz.getName());
    }

    public static String getClassFileName(String qualifiedClassName) {
        return qualifiedClassName.replace('.', '/') + ".class";
    }

    static {
        abbreviationMap.put("boolean", "Z");
        abbreviationMap.put("byte", "B");
        abbreviationMap.put("short", "S");
        abbreviationMap.put("char", "C");
        abbreviationMap.put("int", "I");
        abbreviationMap.put("long", "J");
        abbreviationMap.put("float", "F");
        abbreviationMap.put("double", "D");
    }
}

