/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util.tuple;

import java.io.Serializable;
import java.util.Map;

public final class NameValuePair<K, V>
implements Serializable,
Map.Entry<K, V> {
    private static final long serialVersionUID = 1L;
    public final K name;
    public V value;

    public static <K, V> NameValuePair<K, V> create(K name, V value) {
        return new NameValuePair<K, V>(name, value);
    }

    public NameValuePair(K name, V value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public K getKey() {
        return this.name;
    }

    public K getName() {
        return this.name;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V old = this.value;
        this.value = value;
        return old;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameValuePair pair = (NameValuePair)o;
        if (this.name != null ? !this.name.equals(pair.name) : pair.name != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(pair.value) : pair.value != null);
    }

    @Override
    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pair{name=" + this.name + ", value=" + this.value + '}';
    }
}

