/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.core.Controller;
import com.jfinal.kit.StringKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderFactory;
import java.util.Locale;

public class I18nInterceptor
implements Interceptor {
    private String defaultLanguage = "zh";
    private String defaultCountry = "CN";
    private String languagePara = "language";
    private String countryPara = "country";
    private String localePara = "locale";
    private String skipFlagPara = "skipi18n";

    public void intercept(ActionInvocation ai) {
        String country;
        Controller controller = ai.getController();
        String language = (String)controller.getAttr(this.languagePara);
        if (StringKit.isBlank((String)language)) {
            language = controller.getPara(this.languagePara, this.defaultLanguage);
        }
        if (StringKit.isBlank((String)(country = (String)controller.getAttr(this.countryPara)))) {
            country = controller.getPara(this.countryPara, this.defaultCountry);
        }
        Locale locale = new Locale(language, country);
        controller.setLocaleToCookie(locale);
        controller.setAttr(this.localePara, (Object)locale);
        ai.invoke();
        if (Boolean.TRUE.equals(ai.getController().getAttr(this.skipFlagPara))) {
            return;
        }
        Render render = controller.getRender();
        if (render == null) {
            render = RenderFactory.me().getDefaultRender(ai.getMethodName());
        }
        String view = render.getView();
        String prefix = this.getPrefix(country, language);
        view = view.startsWith("/") ? "/" + prefix + "/" + view.substring(1, view.length()) : "/" + prefix + ai.getViewPath() + view;
    }

    private String getPrefix(String country, String language) {
        String prefix = language;
        if (StringKit.notBlank((String)country)) {
            prefix = language + "_" + country;
        }
        return prefix;
    }

    public I18nInterceptor defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public I18nInterceptor defaultCountry(String defaultCountry) {
        this.defaultCountry = defaultCountry;
        return this;
    }

    public I18nInterceptor languagePara(String languagePara) {
        this.languagePara = languagePara;
        return this;
    }

    public I18nInterceptor countryPara(String countryPara) {
        this.countryPara = countryPara;
        return this;
    }

    public I18nInterceptor localePara(String localePara) {
        this.localePara = localePara;
        return this;
    }

    public I18nInterceptor skipFlagPara(String skipFlagPara) {
        this.skipFlagPara = skipFlagPara;
        return this;
    }
}

