/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor.excel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelExporter {
    public static HSSFWorkbook generateHSSFWorkbook(List<? extends Cellable> toInExcelData, String[] head) throws Exception {
        if (toInExcelData == null || toInExcelData.size() == 0) {
            return null;
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        int rowIndex = 0;
        HSSFRow headRow = sheet.createRow(rowIndex++);
        for (short h = 0; h < head.length; h = (short)(h + 1)) {
            HSSFCell hSSFCell = headRow.createCell(h);
            hSSFCell.setCellValue(head[h]);
        }
        for (Cellable cellable : toInExcelData) {
            HSSFRow row = sheet.createRow(rowIndex++);
            String[] cellValue = cellable.getCellValues();
            for (short j = 0; j < cellValue.length; j = (short)(j + 1)) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(cellValue[j]);
            }
        }
        return wb;
    }

    public static File generateExcelFile(String filePath, List<? extends Cellable> toInExcelData, String[] head) throws Exception {
        if (toInExcelData == null || toInExcelData.size() == 0) {
            return null;
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        int rowIndex = 0;
        HSSFRow headRow = sheet.createRow(rowIndex++);
        for (short h = 0; h < head.length; h = (short)(h + 1)) {
            HSSFCell hSSFCell = headRow.createCell(h);
            hSSFCell.setCellValue(head[h]);
        }
        for (Cellable cellable : toInExcelData) {
            HSSFRow row = sheet.createRow(rowIndex++);
            String[] cellValue = cellable.getCellValues();
            for (short j = 0; j < cellValue.length; j = (short)(j + 1)) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(cellValue[j]);
            }
        }
        File file = new File(new String(filePath.getBytes(), "GBK"));
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        wb.write((OutputStream)fileOutputStream);
        fileOutputStream.close();
        return file;
    }

    public static interface Cellable {
        public String[] getCellValues();
    }
}

