/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor.excel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jfinal.ext.interceptor.excel.CellConvert;
import com.jfinal.ext.interceptor.excel.CellValidate;
import com.jfinal.ext.interceptor.excel.ExcelBean;
import com.jfinal.ext.interceptor.excel.ExcelCell;
import com.jfinal.ext.interceptor.excel.ExcelException;
import com.jfinal.ext.interceptor.excel.RowFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelTools {
    private static final Logger logger = LoggerFactory.getLogger(ExcelTools.class);

    public static Map<Integer, List<List<Object>>> readExcel(File file, ExcelBean excelBean) {
        int start = excelBean.getStart() - 1;
        int end = excelBean.getEnd();
        List rowFilterList = null;
        HashMap<Integer, List<List<Object>>> result = new HashMap<Integer, List<List<Object>>>();
        DecimalFormat format = new DecimalFormat();
        format.setGroupingUsed(false);
        FileInputStream fis = null;
        HSSFWorkbook hwb = null;
        try {
            fis = new FileInputStream(file);
            hwb = new HSSFWorkbook((InputStream)fis);
        }
        catch (Exception e) {
            logger.error("create excel error", (Throwable)e);
            return Maps.newHashMap();
        }
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            HSSFSheet hs = hwb.getSheetAt(i);
            ArrayList sheetList = new ArrayList();
            int rows = hs.getPhysicalNumberOfRows();
            if (end >= rows) {
                end = rows;
            } else if (end <= 0) {
                end = rows + end;
            }
            for (int rowNum = start; rowNum < end; ++rowNum) {
                HSSFRow hr = hs.getRow(rowNum);
                ArrayList<String> sr = new ArrayList<String>();
                int blankCells = 0;
                int celllength = hr.getPhysicalNumberOfCells();
                for (int k = 0; k < celllength; k = (int)((short)(k + 1))) {
                    HSSFCell hc = hr.getCell((short)k);
                    int cellType = 20;
                    try {
                        cellType = hc.getCellType();
                    }
                    catch (NullPointerException e) {
                        sr.add(" ");
                        ++celllength;
                        continue;
                    }
                    String tempStr = "";
                    switch (cellType) {
                        case 0: {
                            String result2 = String.valueOf(hc.getNumericCellValue());
                            if (HSSFDateUtil.isCellDateFormatted((Cell)hc)) {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                tempStr = sdf.format(hc.getDateCellValue());
                                break;
                            }
                            if (result2.toString().indexOf(".") != -1 && result2.toString().indexOf("E") != -1) {
                                tempStr = format.format(hc.getNumericCellValue());
                                break;
                            }
                            tempStr = format.format(hc.getNumericCellValue());
                            break;
                        }
                        case 1: {
                            tempStr = hc.getStringCellValue().trim();
                            break;
                        }
                        case 3: {
                            tempStr = " ";
                            ++blankCells;
                        }
                    }
                    sr.add(StringUtils.deleteWhitespace((String)tempStr));
                }
                if (blankCells >= hr.getPhysicalNumberOfCells()) break;
                ArrayList rowFilterFlagList = Lists.newArrayList();
                if (rowFilterList != null) {
                    for (int k = 0; k < CollectionUtils.size(rowFilterList); ++k) {
                        RowFilter rowFilter = (RowFilter)rowFilterList.get(k);
                        rowFilterFlagList.add(rowFilter.doFilter(rowNum, sr));
                    }
                }
                if (rowFilterFlagList.contains(false)) continue;
                sheetList.add(sr);
            }
            result.put(i, sheetList);
        }
        try {
            fis.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    public static List<List<Object>> readSheet(File file, ExcelBean excelBean) {
        return ExcelTools.readExcel(file, excelBean).get(0);
    }

    public static <T> T digesterSheetWithTwoDimensionalRule(File file, ExcelBean excelBean, Class clazz) {
        HashMap ruleMap = Maps.newHashMap();
        List<ExcelCell> cellList = excelBean.getCellList();
        for (ExcelCell cell : cellList) {
            ruleMap.put(cell.getCol(), cell.getField());
        }
        HashMap destObj = null;
        if (clazz.equals(Map.class)) {
            destObj = Maps.newHashMap();
        } else {
            try {
                destObj = clazz.newInstance();
            }
            catch (Exception e) {
                destObj = null;
            }
        }
        ExcelTools.fillObjectWithTwoDimensionalRule(destObj, ExcelTools.readSheet(file, excelBean), ruleMap);
        return (T)destObj;
    }

    public static <T> List<T> digesterSheetWithOneDimensionalRule(File file, ExcelBean excelBean, Class clazz) throws ExcelException {
        List<List<Object>> srcList = ExcelTools.readSheet(file, excelBean);
        logger.debug("excel data {} ", srcList);
        ArrayList destList = Lists.newArrayList();
        if (srcList == null) {
            return destList;
        }
        for (int i = 0; i < srcList.size(); ++i) {
            List<Object> list = srcList.get(i);
            HashMap destObj = null;
            if (clazz.equals(Map.class)) {
                destObj = Maps.newHashMap();
            } else {
                try {
                    destObj = clazz.newInstance();
                }
                catch (Exception e) {
                    destObj = null;
                }
            }
            ExcelTools.fillObjectWithOneDimensionalRule(destObj, list, excelBean);
            destList.add(destObj);
        }
        return destList;
    }

    public static void fillObjectWithTwoDimensionalRule(Object obj, List<List<Object>> list, Map<String, String> ruleMap) {
        if (obj == null) {
            return;
        }
        Object[][] objs = new Object[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List<Object> templist = list.get(i);
            objs[i] = templist.toArray();
        }
        Set<String> keys = ruleMap.keySet();
        for (String key : keys) {
            String[] xy = StringUtils.split((String)key, (String)",");
            int x = Integer.parseInt(xy[0]) - 1;
            int y = Integer.parseInt(xy[1]) - 1;
            String name = ruleMap.get(key);
            ExcelTools.setProperty(obj, name, objs[x][y]);
        }
    }

    public static void fillObjectWithOneDimensionalRule(Object obj, List<Object> list, ExcelBean excelBean) throws ExcelException {
        if (obj == null || list == null) {
            return;
        }
        List<ExcelCell> cellList = excelBean.getCellList();
        Object[] srcObjs = list.toArray();
        String message = "";
        for (int i = 0; i < srcObjs.length; ++i) {
            Object value = srcObjs[i];
            ArrayList excelCellList = Lists.newArrayList();
            for (ExcelCell excelCell : cellList) {
                String col = excelCell.getCol();
                if (!col.equals(i + 1 + "")) continue;
                excelCellList.add(excelCell);
            }
            if (excelCellList.isEmpty()) continue;
            ExcelCell excelCell = (ExcelCell)excelCellList.get(0);
            String name = excelCell.getField();
            String validateClassName = excelCell.getValidate();
            boolean flag = true;
            if (!StringUtils.isBlank((String)validateClassName)) {
                CellValidate cellValidate = null;
                try {
                    cellValidate = (CellValidate)Class.forName(validateClassName).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                flag = cellValidate.validate(value);
                if (!flag) {
                    message = message + excelCell.getCol() + "\u5217  \u5bfc\u5165\u4e86\u975e\u6cd5\u503c:" + value + "</br>";
                }
            }
            if (!flag) continue;
            String convertClassName = excelCell.getConvert();
            if (!StringUtils.isBlank((String)convertClassName)) {
                try {
                    CellConvert cellConvert = (CellConvert)Class.forName(convertClassName).newInstance();
                    value = cellConvert.convert(value, obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ExcelTools.setProperty(obj, name, value);
        }
        if (StringUtils.isNotBlank((String)message)) {
            throw new ExcelException(message);
        }
    }

    public static Map<String, String> readRule(String rulePath) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(rulePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    private static void setProperty(Object obj, String ognlExpr, Object value) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.put(ognlExpr, value);
        } else {
            Class<?> clazz = obj.getClass();
            try {
                Class typeClass = ExcelTools.getFieldTypeOfClassByOgnl(ognlExpr, clazz);
                if (typeClass.equals(Date.class)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    value = sdf.format(value);
                }
                value = ConvertUtils.convert((Object)value, (Class)typeClass);
                if (typeClass.equals(Double.class)) {
                    try {
                        value = ExcelTools.convertDouble(value);
                    }
                    catch (NumberFormatException e) {
                        value = "0.0";
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
    }

    public static Object convertDouble(Object src) {
        Double total = 0.0;
        String[] srcs = StringUtils.split((String)src.toString(), (String)",");
        for (int i = srcs.length - 1; i >= 0; --i) {
            String s = srcs[i];
            double d = Double.parseDouble(s) * Math.pow(10.0, 3 * (srcs.length - 1 - i));
            total = total + d;
        }
        DecimalFormat format = new DecimalFormat();
        format.setGroupingUsed(false);
        return format.format(total);
    }

    private static Class getFieldTypeOfClassByOgnl(String ognlExpr, Class clazz) {
        ognlExpr = StringUtils.substringBefore((String)ognlExpr, (String)"(");
        String[] fields = StringUtils.split((String)ognlExpr, (String)".");
        Field field = null;
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i];
            if (i == fields.length - 1) break;
            try {
                clazz = Class.forName(clazz.getPackage().getName() + "." + StringUtils.capitalize((String)field.getName()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return field.getType();
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception ex) {
                System.out.println(ex);
                b = new byte[]{};
            }
            for (int n : b) {
                int k = n;
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }
}

