/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.interceptor.excel;

import com.google.common.collect.Lists;
import com.jfinal.core.Controller;
import com.jfinal.ext.interceptor.excel.ExcelBean;
import com.jfinal.ext.interceptor.excel.ExcelException;
import com.jfinal.ext.interceptor.excel.ExcelTools;
import com.jfinal.ext.interceptor.excel.PostExcelProcessor;
import com.jfinal.ext.interceptor.excel.PostListProcessor;
import com.jfinal.ext.interceptor.excel.PreExcelProcessor;
import com.jfinal.ext.interceptor.excel.PreListProcessor;
import com.jfinal.ext.interceptor.excel.RowFilter;
import com.jfinal.log.Logger;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ExcelUploadController
extends Controller {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private File excelFile;
    private int start;
    private int end;
    private String rule;
    private String model;
    private Digester digester = DigesterLoader.createDigester((URL)ExcelUploadController.class.getClassLoader().getResource("excel.xml"));
    private ExcelBean excelBean;

    public void index() throws Exception {
        String realPath = ExcelUploadController.class.getResource("/").getFile() + "excelrule/" + this.rule + ".xml";
        this.excelBean = (ExcelBean)this.digester.parse(new File(realPath));
        String modeName = this.excelBean.getName() + "." + this.rule;
        Object mgr = null;
        Method saveMethod = mgr.getClass().getMethod("save" + this.rule, Class.forName(modeName));
        List list = null;
        try {
            list = ExcelTools.digesterSheetWithOneDimensionalRule(this.excelFile, this.excelBean, Class.forName(modeName));
        }
        catch (ExcelException e) {
            this.renderText(e.getMessage());
        }
        this.execPreListProcessor(list);
        for (Object obj : list) {
            this.execPreExcelProcessor(obj);
            saveMethod.invoke(mgr, obj);
            this.execPostExcelProcessor(obj);
        }
        this.excePostListProcessor(list);
    }

    private void excePostListProcessor(List list) {
        String postListProcessorClassName = this.excelBean.getPostListProcessor();
        if (!StringUtils.isBlank((String)postListProcessorClassName)) {
            PostListProcessor postListProcessor = null;
            try {
                postListProcessor = (PostListProcessor)Class.forName(postListProcessorClassName).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
            postListProcessor.process(list);
        }
    }

    private void execPostExcelProcessor(Object obj) {
        String postExcelProcessorClassName = this.excelBean.getPostExcelProcessor();
        if (!StringUtils.isBlank((String)postExcelProcessorClassName)) {
            PostExcelProcessor postExcelProcessor = null;
            try {
                postExcelProcessor = (PostExcelProcessor)Class.forName(postExcelProcessorClassName).newInstance();
            }
            catch (Exception e) {
                this.logger.error("create PostExcelProcessor error", (Throwable)e);
            }
            postExcelProcessor.process(obj);
        }
    }

    private void execPreExcelProcessor(Object obj) {
        String preExcelProcessorClassName = this.excelBean.getPreExcelProcessor();
        if (!StringUtils.isBlank((String)preExcelProcessorClassName)) {
            PreExcelProcessor preExcelProcessor = null;
            try {
                preExcelProcessor = (PreExcelProcessor)Class.forName(preExcelProcessorClassName).newInstance();
            }
            catch (Exception e) {
                this.logger.error("create PreExcelProcessor error", (Throwable)e);
            }
            preExcelProcessor.process(obj);
        }
    }

    private void execPreListProcessor(List list) {
        String preListProcessorClassName = this.excelBean.getPreListProcessor();
        if (!StringUtils.isBlank((String)preListProcessorClassName)) {
            PreListProcessor preListProcessor = null;
            try {
                preListProcessor = (PreListProcessor)Class.forName(preListProcessorClassName).newInstance();
            }
            catch (Exception e) {
                this.logger.error("create PreExcelProcessor error", (Throwable)e);
            }
            preListProcessor.process(list);
        }
    }

    private List<RowFilter> getRowFilterList(String rowFilter) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ArrayList rowFilterList = Lists.newArrayList();
        String[] rowFilters = StringUtils.split((String)StringUtils.deleteWhitespace((String)rowFilter), (String)",");
        if (ArrayUtils.getLength((Object)rowFilters) > 0) {
            for (String string : rowFilters) {
                rowFilterList.add((RowFilter)Class.forName(string).newInstance());
            }
        }
        return rowFilterList;
    }

    public File getExcelFile() {
        return this.excelFile;
    }

    public void setExcelFile(File excelFile) {
        this.excelFile = excelFile;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }
}

