/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.kit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jfinal.ext.interceptor.CallbackListener;
import com.jfinal.ext.interceptor.pageinfo.Parent;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.TableInfo;
import com.jfinal.plugin.activerecord.TableInfoMapping;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class ModelExt<M extends ModelExt<M>>
extends Model<M> {
    private String deleteColumnLabel = "deleteflag";
    private String version = "version";
    private static List<CallbackListener> callbackListeners = Lists.newArrayList();
    private Class<? extends ModelExt<M>> clazz;

    public ModelExt() {
        Type genericSuperclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
        this.clazz = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
    }

    public static void addCallbackListener(CallbackListener callbackListener) {
        callbackListeners.add(callbackListener);
    }

    public boolean pseudoDelete() {
        return false;
    }

    public boolean save() {
        for (CallbackListener callbackListener : callbackListeners) {
            callbackListener.beforeSave(this);
        }
        TableInfo tableInfo = TableInfoMapping.me().getTableInfo(this.clazz);
        if (this.pseudoDelete()) {
            if (!tableInfo.hasColumnLabel(this.deleteColumnLabel)) {
                throw new ActiveRecordException("The deleteColumnLabel (" + this.deleteColumnLabel + ") is not exist");
            }
            this.set(this.deleteColumnLabel, 0);
        }
        boolean result = super.save();
        for (CallbackListener callbackListener : callbackListeners) {
            callbackListener.afterSave(this);
        }
        return result;
    }

    public boolean update() {
        for (CallbackListener callbackListener : callbackListeners) {
            callbackListener.beforeUpdate(this);
        }
        boolean result = super.update();
        for (CallbackListener callbackListener : callbackListeners) {
            callbackListener.afterUpdate(this);
        }
        return result;
    }

    public boolean delete() {
        TableInfo tableInfo = TableInfoMapping.me().getTableInfo(this.clazz);
        for (CallbackListener callbackListener : callbackListeners) {
            callbackListener.beforeDelete(this);
        }
        boolean result = false;
        if (this.pseudoDelete()) {
            if (!tableInfo.hasColumnLabel(this.deleteColumnLabel)) {
                throw new ActiveRecordException("The deleteColumnLabel (" + this.deleteColumnLabel + ") is not exist");
            }
            this.set(this.deleteColumnLabel, 1);
            result = this.update();
        } else {
            result = super.delete();
        }
        for (CallbackListener callbackListener : callbackListeners) {
            callbackListener.afterDelete(this);
        }
        return result;
    }

    public boolean deleteById(Object id) {
        TableInfo tableInfo = TableInfoMapping.me().getTableInfo(this.clazz);
        for (CallbackListener callbackListener : callbackListeners) {
            callbackListener.beforeDelete(this);
        }
        boolean result = false;
        if (this.pseudoDelete()) {
            if (!tableInfo.hasColumnLabel(this.deleteColumnLabel)) {
                throw new ActiveRecordException("The deleteColumnLabel (" + this.deleteColumnLabel + ") is not exist");
            }
            String pKey = tableInfo.getPrimaryKey();
            if (id == null) {
                throw new ActiveRecordException("You can't update model without Primary Key.");
            }
            String sql = "update " + tableInfo.getTableName() + " set " + this.deleteColumnLabel + " = 1 where " + pKey + " = ?";
            result = Db.update((String)sql, (Object[])new Object[]{id}) >= 1;
        } else {
            result = super.deleteById(id);
        }
        for (CallbackListener callbackListener : callbackListeners) {
            callbackListener.afterDelete(this);
        }
        return result;
    }

    public int deleteAll() {
        String primaryKey = TableInfoMapping.me().getTableInfo(this.clazz).getPrimaryKey();
        return Db.update((String)("delete from " + this.tableName() + " where " + primaryKey + "=?"));
    }

    public int deleteByColumn(String column, Object value) {
        return this.deleteByColumns(Lists.newArrayList((Object[])new String[]{column}), Lists.newArrayList((Object[])new Object[]{value}));
    }

    public int deleteByColumns(List<String> columns, List<Object> values) {
        Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"columns is empty");
        Preconditions.checkArgument((values.size() > 0 ? 1 : 0) != 0, (Object)"values is empty");
        Preconditions.checkArgument((values.size() == columns.size() ? 1 : 0) != 0, (Object)"column size != values size");
        String sql = "";
        TableInfo tableInfo = TableInfoMapping.me().getTableInfo(this.clazz);
        if (this.pseudoDelete()) {
            if (!tableInfo.hasColumnLabel(this.deleteColumnLabel)) {
                throw new ActiveRecordException("The deleteColumnLabel (" + this.deleteColumnLabel + ") is not exist");
            }
            String pKey = tableInfo.getPrimaryKey();
            sql = sql + "update " + tableInfo.getTableName() + " set " + this.deleteColumnLabel + " = 1";
        } else {
            sql = sql + "delete from " + tableInfo.getTableName();
        }
        sql = sql + " where 1=1";
        for (String column : columns) {
            sql = sql + " and " + column + " = ?";
        }
        return Db.update((String)sql, (Object[])values.toArray());
    }

    public List<M> findAll() {
        String sql = "select * from " + this.tableName();
        if (this.pseudoDelete()) {
            sql = sql + " where " + this.deleteColumnLabel + " is null or " + this.deleteColumnLabel + " !=1 ";
        }
        return this.find(sql);
    }

    public M findFirstByColumn(String column, Object value) {
        List<M> result = this.findByColumns(Lists.newArrayList((Object[])new String[]{column}), Lists.newArrayList((Object[])new Object[]{value}));
        return (M)((Object)(result.size() > 0 ? (ModelExt)((Object)result.get(0)) : null));
    }

    public List<M> findByColumn(String column, Object value) {
        return this.findByColumns(Lists.newArrayList((Object[])new String[]{column}), Lists.newArrayList((Object[])new Object[]{value}));
    }

    public M findFirstByColumns(List<String> columns, List<Object> values) {
        List<M> result = this.findByColumns(columns, values);
        return (M)((Object)(result.size() > 0 ? (ModelExt)((Object)result.get(0)) : null));
    }

    public List<M> findByColumns(List<String> columns, List<Object> values) {
        Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"columns is empty");
        Preconditions.checkArgument((values.size() > 0 ? 1 : 0) != 0, (Object)"values is empty");
        Preconditions.checkArgument((values.size() == columns.size() ? 1 : 0) != 0, (Object)"column size != values size");
        String sql = "select * from " + this.tableName() + " where 1=1";
        if (this.pseudoDelete()) {
            sql = sql + " and " + this.deleteColumnLabel + " is null or " + this.deleteColumnLabel + " !=1 ";
        }
        for (String column : columns) {
            sql = sql + " and " + column + " = ?";
        }
        return this.find(sql, values.toArray());
    }

    public List<M> children(Class<? extends Model> model) {
        Parent child = model.getAnnotation(Parent.class);
        String foreignKey = child.foreignKey();
        Class<Model<?>> childModel = child.model();
        String childTableName = TableInfoMapping.me().getTableInfo(childModel).getTableName();
        String primaryKey = TableInfoMapping.me().getTableInfo(this.clazz).getPrimaryKey();
        try {
            return childModel.newInstance().find("select * from " + childTableName + " where " + foreignKey + "= ?", new Object[]{this.get(primaryKey)});
        }
        catch (Exception e) {
            throw new ActiveRecordException(e.getMessage(), (Throwable)e);
        }
    }

    public M parent(Class<? extends Model> model) {
        Parent parent = model.getAnnotation(Parent.class);
        String foreignKey = parent.foreignKey();
        Class<Model<?>> parentModel = parent.model();
        String parentTableName = TableInfoMapping.me().getTableInfo(parentModel).getTableName();
        String primaryKey = TableInfoMapping.me().getTableInfo(this.clazz).getPrimaryKey();
        try {
            return (M)((Object)((ModelExt)parentModel.newInstance().findFirst("select * from " + parentTableName + " where " + foreignKey + "= ?", new Object[]{this.get(primaryKey)})));
        }
        catch (Exception e) {
            throw new ActiveRecordException(e.getMessage(), (Throwable)e);
        }
    }

    private String tableName() {
        return TableInfoMapping.me().getTableInfo(this.clazz).getTableName();
    }
}

