/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.cron;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.log.Logger;
import com.jfinal.plugin.IPlugin;
import it.sauronsoftware.cron4j.Scheduler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Cron4jPlugin
implements IPlugin {
    private static final String JOB = "job";
    private final Logger log = Logger.getLogger(this.getClass());
    private Map<String, Runnable> jobs = Maps.newHashMap();
    private String config = "job.properties";
    private Scheduler scheduler;
    private Properties properties;

    public Cron4jPlugin add(String jobCronExp, Runnable job) {
        this.jobs.put(jobCronExp, job);
        return this;
    }

    public Cron4jPlugin config(String config) {
        this.config = config;
        return this;
    }

    public boolean start() {
        this.scheduler = new Scheduler();
        this.loadJobsFromProperties();
        Set<Map.Entry<String, Runnable>> set = this.jobs.entrySet();
        for (Map.Entry<String, Runnable> entry : set) {
            this.scheduler.schedule(entry.getKey(), entry.getValue());
            this.log.debug(entry.getValue() + " has been scheduled to run and repeat based on expression: " + entry.getKey());
        }
        this.scheduler.start();
        return true;
    }

    private void loadJobsFromProperties() {
        this.loadProperties();
        if (this.properties == null) {
            return;
        }
        Enumeration<Object> enums = this.properties.keys();
        while (enums.hasMoreElements()) {
            String key = enums.nextElement() + "";
            if (!key.endsWith(JOB) || !this.isEnableJob(this.enable(key))) continue;
            String jobClassName = this.properties.get(key) + "";
            String jobCronExp = this.properties.getProperty(this.cronKey(key)) + "";
            Class clazz = (Class)Reflect.on(jobClassName).get();
            try {
                this.jobs.put(jobCronExp, (Runnable)clazz.newInstance());
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    private String enable(String key) {
        return key.substring(0, key.lastIndexOf(JOB)) + "enable";
    }

    private String cronKey(String key) {
        return key.substring(0, key.lastIndexOf(JOB)) + "cron";
    }

    private boolean isEnableJob(String enableKey) {
        Object enable = this.properties.get(enableKey);
        return enable == null || !"false".equalsIgnoreCase((enable + "").trim());
    }

    private void loadProperties() {
        this.properties = new Properties();
        this.log.debug("config is: " + this.config);
        InputStream is = Cron4jPlugin.class.getClassLoader().getResourceAsStream(this.config);
        if (is == null) {
            return;
        }
        try {
            this.properties.load(is);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        this.log.debug("------------load Propteries---------------");
        this.log.debug(this.properties.toString());
        this.log.debug("------------------------------------------");
    }

    public boolean stop() {
        this.scheduler.stop();
        return true;
    }
}

