/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.quartz;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.log.Logger;
import com.jfinal.plugin.IPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzPlugin
implements IPlugin {
    private static final String JOB = "job";
    private final Logger logger = Logger.getLogger(this.getClass());
    private Map<String, Job> jobs = Maps.newHashMap();
    private SchedulerFactory sf;
    private Scheduler sched;
    private String config = "job.properties";
    private Properties properties;

    public QuartzPlugin(String config) {
        this.config = config;
    }

    public QuartzPlugin() {
    }

    public boolean start() {
        this.sf = new StdSchedulerFactory();
        try {
            this.sched = this.sf.getScheduler();
        }
        catch (SchedulerException e) {
            Throwables.propagate((Throwable)e);
        }
        this.loadProperties();
        Enumeration<Object> enums = this.properties.keys();
        while (enums.hasMoreElements()) {
            String key = enums.nextElement() + "";
            if (!key.endsWith(JOB) || !this.isEnableJob(this.enable(key))) continue;
            String jobClassName = this.properties.get(key) + "";
            String jobCronExp = this.properties.getProperty(this.cronKey(key)) + "";
            Class clazz = (Class)Reflect.on(jobClassName).get();
            JobDetail job = new JobDetail(jobClassName, jobClassName, clazz);
            CronTrigger trigger = null;
            try {
                trigger = new CronTrigger(jobClassName, jobClassName, jobCronExp);
            }
            catch (ParseException e) {
                Throwables.propagate((Throwable)e);
            }
            Date ft = null;
            try {
                ft = this.sched.scheduleJob(job, (Trigger)trigger);
                this.sched.start();
            }
            catch (SchedulerException e) {
                Throwables.propagate((Throwable)e);
            }
            this.logger.debug(job.getKey() + " has been scheduled to run at: " + ft + " and repeat based on expression: " + trigger.getCronExpression());
        }
        return true;
    }

    private String enable(String key) {
        return key.substring(0, key.lastIndexOf(JOB)) + "enable";
    }

    private String cronKey(String key) {
        return key.substring(0, key.lastIndexOf(JOB)) + "cron";
    }

    private boolean isEnableJob(String enableKey) {
        Object enable = this.properties.get(enableKey);
        return enable == null || !"false".equalsIgnoreCase((enable + "").trim());
    }

    private void loadProperties() {
        this.properties = new Properties();
        InputStream is = QuartzPlugin.class.getClassLoader().getResourceAsStream(this.config);
        try {
            this.properties.load(is);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        this.logger.debug("------------load Propteries---------------");
        this.logger.debug(this.properties.toString());
        this.logger.debug("------------------------------------------");
    }

    public boolean stop() {
        try {
            this.sched.shutdown();
        }
        catch (SchedulerException e) {
            Throwables.propagate((Throwable)e);
        }
        return true;
    }
}

