/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.sqlinxml;

import com.jfinal.ext.kit.JaxbKit;
import com.jfinal.ext.plugin.sqlinxml.SqlGroup;
import com.jfinal.ext.plugin.sqlinxml.SqlItem;
import com.jfinal.log.Logger;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;

public class SqlKit {
    protected static final Logger LOG = Logger.getLogger(SqlKit.class);
    private static Map<String, String> sqlMap;

    public static String sql(String groupNameAndsqlId) {
        if (sqlMap == null) {
            throw new NullPointerException("SqlInXmlPlugin not start");
        }
        return sqlMap.get(groupNameAndsqlId);
    }

    static void clearSqlMap() {
        sqlMap.clear();
    }

    static void init() {
        File[] files;
        sqlMap = new HashMap<String, String>();
        File file = new File(SqlKit.class.getClassLoader().getResource("").getFile());
        for (File xmlfile : files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith("sql.xml");
            }
        })) {
            SqlGroup group = JaxbKit.unmarshal(xmlfile, SqlGroup.class);
            String name = group.name;
            if (name == null || name.trim().equals("")) {
                name = xmlfile.getName();
            }
            for (SqlItem sqlItem : group.sqlItems) {
                sqlMap.put(name + "." + sqlItem.id, sqlItem.value);
            }
        }
        LOG.debug("sqlMap" + sqlMap);
    }
}

