/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render.chart.funshion;

import com.jfinal.ext.kit.KeyLabel;
import com.jfinal.ext.render.chart.funshion.FusionCharts;
import com.jfinal.ext.render.chart.funshion.GraphChart;
import com.jfinal.ext.render.chart.funshion.PieChart;
import com.jfinal.kit.StringKit;
import com.jfinal.log.Logger;
import java.util.List;

public class CreateCharts {
    protected static final Logger LOG = Logger.getLogger(CreateCharts.class);

    public static String createChart(PieChart chart) {
        String strXML = "";
        strXML = strXML + "<chart caption='" + chart.getCaption() + "' xAxisName='" + chart.getXAxisName() + "' yAxisName='" + chart.getYAxisName() + "' showValues='1' formatNumberScale='1' baseFontSize ='12' bgColor='#CCCCCC'  rotateYAxisName='0' >";
        List<KeyLabel> list = chart.getList();
        for (KeyLabel key : list) {
            strXML = strXML + "<set label='" + key.getLabel() + "' value='" + key.getKey() + "' />";
        }
        strXML = strXML + "</chart>";
        FusionCharts charts = new FusionCharts();
        String chartCode = charts.createChartHTML(chart.getCharUrl(), "", strXML, "myNext", chart.getCharWidth(), chart.getCharHigh(), false);
        return chartCode;
    }

    public static String createPieChart(PieChart chart) {
        String strXML = "";
        strXML = strXML + "<chart caption='" + chart.getCaption() + "' palette='4' baseFontSize ='12' showNames='1' >";
        List<KeyLabel> list = chart.getList();
        for (KeyLabel key : list) {
            String tkey = key.getKey();
            if (StringKit.isBlank((String)tkey)) {
                tkey = "0";
            }
            strXML = strXML + "<set label='" + key.getLabel() + "' value='" + tkey + "' />";
        }
        strXML = strXML + "</chart>";
        FusionCharts charts = new FusionCharts();
        String chartCode = charts.createChartHTML(chart.getCharUrl(), "", strXML, "chartId", chart.getCharWidth(), chart.getCharHigh(), false);
        return chartCode;
    }

    public static String createMultiCharts(GraphChart multiCharts) {
        StringBuffer strXML = new StringBuffer("");
        strXML.append("<chart caption='" + multiCharts.getCaption() + "' subcaption='" + multiCharts.getSubcaption() + "' lineThickness='1'  numDivLines='4' numberSuffix='" + multiCharts.getNumberSuffix() + "' numberPrefix='" + multiCharts.getNumberPrefix() + "' showValues='1' formatNumberScale='0' anchorRadius='5' divLineAlpha='20' " + "divLineColor='#666666 ' bgColor='#6633FF' alternateHGridColor='#6633FF' " + "divLineIsDashed='1' showAlternateHGridColor='1' alternateHGridAlpha='5'  shadowAlpha='40' labelStep='1' " + "numvdivlines='5' chartRightMargin='35' bgAngle='270' bgAlpha='10,10' rotateYAxisName='0' baseFontSize ='12' >");
        strXML.append("<categories>");
        for (String lable : multiCharts.getLabels()) {
            strXML.append("<category label='" + lable + "'/>");
        }
        strXML.append("</categories>");
        List<String> seriesName = multiCharts.getLeftSeriesNames();
        List<List<String>> list = multiCharts.getLeftValues();
        List<String> colors = multiCharts.getColors();
        for (int i = 0; i < seriesName.size(); ++i) {
            strXML.append("<dataset seriesName='" + seriesName.get(i) + "' anchorBgColor='" + colors.get(i) + "' color='" + colors.get(i) + "'>");
            List<String> values = list.get(i);
            for (int j = 0; j < values.size(); ++j) {
                strXML.append("<set value='" + values.get(j) + "'/>");
            }
            strXML.append("</dataset>");
        }
        List<String> sSeriesNames = multiCharts.getRightSeriesNames();
        List<List<String>> slist = multiCharts.getRightValues();
        if (sSeriesNames != null) {
            for (int i = 0; i < sSeriesNames.size(); ++i) {
                strXML.append("<dataset  parentYAxis='S' seriesName='" + sSeriesNames.get(i) + "' anchorBgColor='" + colors.get(i) + "' color='" + colors.get(i) + "'>");
                List<String> values = slist.get(i);
                for (int j = 0; j < values.size(); ++j) {
                    strXML.append("<set value='" + values.get(j) + "'/>");
                }
                strXML.append("</dataset>");
            }
        }
        strXML.append("</chart>");
        FusionCharts charts = new FusionCharts();
        String chartCode = charts.createChartHTML(multiCharts.getCharUrl(), "", strXML.toString(), "myNext", multiCharts.getCharWidth(), multiCharts.getCharHigh(), false);
        return chartCode;
    }
}

