/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render.excel;

import com.google.common.base.Preconditions;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.Region;

public class PoiKit {
    private static final int HEADER_ROW = 1;
    private static final int MAX_ROWS = 65536;
    private String sheetName = "new sheet";
    private int cellWidth = 8000;
    private int headerRow;
    private String[] headers = new String[0];
    private String[] columns;
    private List<?> data;

    public PoiKit(List<?> data) {
        this.data = data;
    }

    public static PoiKit with(List<?> data) {
        return new PoiKit(data);
    }

    public HSSFWorkbook export() {
        Preconditions.checkNotNull((Object)this.headers, (Object)"headers can not be null");
        Preconditions.checkNotNull((Object)this.columns, (Object)"columns can not be null");
        Preconditions.checkArgument((this.cellWidth >= 0 ? 1 : 0) != 0, (Object)"cellWidth < 0");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(this.sheetName);
        HSSFRow row = null;
        HSSFCell cell = null;
        if (this.headers.length > 0) {
            row = sheet.createRow(0);
            if (this.headerRow <= 0) {
                this.headerRow = 1;
            }
            this.headerRow = Math.min(this.headerRow, 65536);
            int lenH = this.headers.length;
            for (int h = 0; h < lenH; ++h) {
                org.apache.poi.hssf.util.Region region = new org.apache.poi.hssf.util.Region(0, (short)h, (short)this.headerRow - 1, (short)h);
                sheet.addMergedRegion((Region)region);
                sheet.getNumMergedRegions();
                if (this.cellWidth > 0) {
                    sheet.setColumnWidth(h, this.cellWidth);
                }
                cell = row.createCell(h);
                cell.setCellValue(this.headers[h]);
            }
        }
        if (this.data.size() == 0) {
            return wb;
        }
        int len = this.data.size();
        for (int i = 0; i < len; ++i) {
            row = sheet.createRow(i + this.headerRow);
            Object obj = this.data.get(i);
            if (obj == null) continue;
            if (obj instanceof Map) {
                PoiKit.processAsMap(this.columns, row, obj);
                continue;
            }
            if (obj instanceof Model) {
                PoiKit.processAsModel(this.columns, row, obj);
                continue;
            }
            if (!(obj instanceof Record)) continue;
            PoiKit.processAsRecord(this.columns, row, obj);
        }
        return wb;
    }

    private static void processAsMap(String[] columns, HSSFRow row, Object obj) {
        Map map = (Map)obj;
        if (columns.length == 0) {
            Set keys = map.keySet();
            int columnIndex = 0;
            for (String key : keys) {
                HSSFCell cell = row.createCell(columnIndex);
                cell.setCellValue(map.get(key) + "");
                ++columnIndex;
            }
        } else {
            int lenJ = columns.length;
            for (int j = 0; j < lenJ; ++j) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(map.get(columns[j]) + "");
            }
        }
    }

    private static void processAsModel(String[] columns, HSSFRow row, Object obj) {
        Model model = (Model)obj;
        Set entries = model.getAttrsEntrySet();
        if (columns.length == 0) {
            int columnIndex = 0;
            for (Map.Entry entry : entries) {
                HSSFCell cell = row.createCell(columnIndex);
                cell.setCellValue(entry.getValue() + "");
                ++columnIndex;
            }
        } else {
            int lenJ = columns.length;
            for (int j = 0; j < lenJ; ++j) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(model.get(columns[j]) + "");
            }
        }
    }

    private static void processAsRecord(String[] columns, HSSFRow row, Object obj) {
        Record record = (Record)obj;
        Map map = record.getColumns();
        if (columns.length == 0) {
            record.getColumns();
            Set keys = map.keySet();
            int columnIndex = 0;
            for (String key : keys) {
                HSSFCell cell = row.createCell(columnIndex);
                cell.setCellValue(record.get(key) + "");
                ++columnIndex;
            }
        } else {
            int lenJ = columns.length;
            for (int j = 0; j < lenJ; ++j) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(map.get(columns[j]) + "");
            }
        }
    }

    public PoiKit sheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public PoiKit cellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
        return this;
    }

    public PoiKit headerRow(int headerRow) {
        this.headerRow = headerRow;
        return this;
    }

    public PoiKit headers(String[] headers) {
        this.headers = headers;
        return this;
    }

    public PoiKit columns(String[] columns) {
        this.columns = columns;
        return this;
    }
}

