/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render.excel;

import com.jfinal.ext.render.excel.PoiKit;
import com.jfinal.log.Logger;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;

public class PoiRender
extends Render {
    protected final Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass());
    private static final String CONTENT_TYPE = "application/msexcel;charset=" + PoiRender.getEncoding();
    private List<?> data;
    private String[] headers;
    private String sheetName = "sheet1";
    private int cellWidth;
    private String[] columns = new String[0];
    private String fileName = "file1.xls";
    private int headerRow;

    public PoiRender(List<?> data) {
        this.data = data;
    }

    public static PoiRender me(List<?> data) {
        return new PoiRender(data);
    }

    public void render() {
        this.response.reset();
        this.response.setHeader("Content-disposition", "attachment; filename=" + this.fileName);
        this.response.setContentType(CONTENT_TYPE);
        ServletOutputStream os = null;
        try {
            os = this.response.getOutputStream();
            PoiKit.with(this.data).sheetName(this.sheetName).headerRow(this.headerRow).headers(this.headers).columns(this.columns).cellWidth(this.cellWidth).export().write((OutputStream)os);
        }
        catch (Exception e) {
            throw new RenderException((Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            catch (IOException e) {
                this.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public PoiRender headers(String ... headers) {
        this.headers = headers;
        return this;
    }

    public PoiRender headerRow(int headerRow) {
        this.headerRow = headerRow;
        return this;
    }

    public PoiRender columns(String ... columns) {
        this.columns = columns;
        return this;
    }

    public PoiRender sheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public PoiRender cellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
        return this;
    }

    public PoiRender fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }
}

