/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryPolicy;
import com.netflix.curator.drivers.TracerDriver;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryLoop {
    private boolean isDone = false;
    private int retryCount = 0;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final long startTimeMs = System.currentTimeMillis();
    private final RetryPolicy retryPolicy;
    private final AtomicReference<TracerDriver> tracer;

    public static <T> T callWithRetry(CuratorZookeeperClient curatorZookeeperClient, Callable<T> callable) throws Exception {
        T t = null;
        RetryLoop retryLoop = curatorZookeeperClient.newRetryLoop();
        while (retryLoop.shouldContinue()) {
            try {
                curatorZookeeperClient.internalBlockUntilConnectedOrTimedOut();
                t = callable.call();
                retryLoop.markComplete();
            }
            catch (Exception exception) {
                retryLoop.takeException(exception);
            }
        }
        return t;
    }

    RetryLoop(RetryPolicy retryPolicy, AtomicReference<TracerDriver> atomicReference) {
        this.retryPolicy = retryPolicy;
        this.tracer = atomicReference;
    }

    public boolean shouldContinue() {
        return !this.isDone;
    }

    public void markComplete() {
        this.isDone = true;
    }

    public static boolean shouldRetry(int n) {
        return n == KeeperException.Code.CONNECTIONLOSS.intValue() || n == KeeperException.Code.OPERATIONTIMEOUT.intValue() || n == KeeperException.Code.SESSIONMOVED.intValue() || n == KeeperException.Code.SESSIONEXPIRED.intValue();
    }

    public static boolean isRetryException(Throwable throwable) {
        if (throwable instanceof KeeperException) {
            KeeperException keeperException = (KeeperException)throwable;
            return RetryLoop.shouldRetry(keeperException.code().intValue());
        }
        return false;
    }

    public void takeException(Exception exception) throws Exception {
        boolean bl = true;
        if (RetryLoop.isRetryException(exception)) {
            this.log.debug("Retry-able exception received", (Throwable)exception);
            if (this.retryPolicy.allowRetry(this.retryCount++, System.currentTimeMillis() - this.startTimeMs)) {
                this.tracer.get().addCount("retries-disallowed", 1);
                this.log.debug("Retry policy not allowing retry");
                bl = false;
            } else {
                this.tracer.get().addCount("retries-allowed", 1);
                this.log.debug("Retrying operation");
            }
        }
        if (bl) {
            throw exception;
        }
    }
}

