/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.cache;

import com.stormpath.sdk.cache.CacheConfigurationBuilder;
import com.stormpath.sdk.impl.cache.CacheConfiguration;
import com.stormpath.sdk.impl.cache.DefaultCacheConfiguration;
import com.stormpath.sdk.impl.util.Duration;
import com.stormpath.sdk.lang.Assert;
import java.util.concurrent.TimeUnit;

public class DefaultCacheConfigurationBuilder
implements CacheConfigurationBuilder {
    private final String name;
    private Duration timeToLive;
    private Duration timeToIdle;

    public DefaultCacheConfigurationBuilder(String name) {
        Assert.hasText((String)name, (String)"Cache Region name cannot be null or empty.");
        this.name = name;
    }

    public CacheConfigurationBuilder withTimeToLive(long ttl, TimeUnit ttlTimeUnit) {
        this.timeToLive = DefaultCacheConfiguration.toDuration(ttl, ttlTimeUnit);
        return this;
    }

    public CacheConfigurationBuilder withTimeToIdle(long tti, TimeUnit ttiTimeUnit) {
        this.timeToIdle = DefaultCacheConfiguration.toDuration(tti, ttiTimeUnit);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    public Duration getTimeToIdle() {
        return this.timeToIdle;
    }

    public CacheConfiguration build() {
        return new DefaultCacheConfiguration(this.getName(), this.getTimeToLive(), this.getTimeToIdle());
    }
}

