/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.directory;

import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.DateProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultCustomData
extends AbstractInstanceResource
implements CustomData {
    static final DateProperty CREATED_AT = new DateProperty("createdAt");
    static final DateProperty MODIFIED_AT = new DateProperty("modifiedAt");
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultCustomData.createPropertyDescriptorMap(CREATED_AT, MODIFIED_AT);

    public DefaultCustomData(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultCustomData(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Date getCreatedAt() {
        return this.getDateProperty(CREATED_AT);
    }

    public Date getModifiedAt() {
        return this.getDateProperty(MODIFIED_AT);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.readLock.lock();
        try {
            int n = this.properties.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.properties.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        this.readLock.lock();
        try {
            boolean bl = this.properties.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = this.properties.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Object get(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        return super.getProperty(key.toString());
    }

    public Object put(String key, Object value) {
        return super.setProperty(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        this.writeLock.lock();
        try {
            Object object = this.properties.remove(key);
            this.dirtyProperties.remove(key);
            this.deletedPropertyNames.add(key.toString());
            this.dirty = true;
            Object v = object;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends String, ?> m) {
        if (Collections.isEmpty(m)) {
            return;
        }
        Set<Map.Entry<String, ?>> entrySet = m.entrySet();
        this.writeLock.lock();
        try {
            for (Map.Entry<String, ?> entry : entrySet) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            HashSet<String> propertiesToFilter = new HashSet<String>();
            propertiesToFilter.add("href");
            propertiesToFilter.addAll(this.getPropertyDescriptors().keySet());
            for (String propertyName : this.getPropertyNames()) {
                if (propertiesToFilter.contains(propertyName)) continue;
                this.properties.remove(propertyName);
                this.dirtyProperties.remove(propertyName);
                this.deletedPropertyNames.add(propertyName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> keySet() {
        return super.getPropertyNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> values() {
        this.readLock.lock();
        try {
            Collection<Object> collection = this.properties.values();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<String, Object>> entrySet() {
        this.readLock.lock();
        try {
            Set<Map.Entry<String, Object>> set = this.properties.entrySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void save() {
        if (this.isDirty()) {
            if (this.hasRemovedProperties()) {
                this.deleteRemovedProperties();
            }
            if (this.hasNewProperties()) {
                super.save();
            }
        }
    }

    public void deleteRemovedProperties() {
        Set<String> deletedPropertyNames = this.getDeletedPropertyNames();
        for (String deletedPropertyName : deletedPropertyNames) {
            this.getDataStore().deleteResourceProperty(this, deletedPropertyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemovedProperties() {
        this.readLock.lock();
        try {
            boolean bl = !this.deletedPropertyNames.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewProperties() {
        this.readLock.lock();
        try {
            boolean bl = !this.dirtyProperties.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

