/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.http.authc;

import com.stormpath.sdk.client.ApiKey;
import com.stormpath.sdk.impl.http.Request;
import com.stormpath.sdk.impl.http.authc.MacAlgorithm;
import com.stormpath.sdk.impl.http.authc.Signer;
import com.stormpath.sdk.impl.http.support.SignatureException;
import com.stormpath.sdk.impl.util.RequestUtils;
import com.stormpath.sdk.impl.util.StringInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.SimpleTimeZone;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sauthc1Signer
implements Signer {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String HOST_HEADER = "Host";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String STORMAPTH_DATE_HEADER = "X-Stormpath-Date";
    public static final String ID_TERMINATOR = "sauthc1_request";
    public static final String ALGORITHM = "HMAC-SHA-256";
    public static final String AUTHENTICATION_SCHEME = "SAuthc1";
    public static final String SAUTHC1_ID = "sauthc1Id";
    public static final String SAUTHC1_SIGNED_HEADERS = "sauthc1SignedHeaders";
    public static final String SAUTHC1_SIGNATURE = "sauthc1Signature";
    public static final String DATE_FORMAT = "yyyyMMdd";
    public static final String TIMESTAMP_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static final String TIME_ZONE = "UTC";
    private static final String NL = "\n";
    private static final Logger log = LoggerFactory.getLogger(Sauthc1Signer.class);

    @Override
    public void sign(Request request, ApiKey apiKey) throws SignatureException {
        Date date = new Date();
        String nonce = UUID.randomUUID().toString();
        this.sign(request, apiKey, date, nonce);
    }

    public void sign(Request request, ApiKey apiKey, Date date, String nonce) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(new SimpleTimeZone(0, TIME_ZONE));
        SimpleDateFormat timestampFormat = new SimpleDateFormat(TIMESTAMP_FORMAT);
        timestampFormat.setTimeZone(new SimpleTimeZone(0, TIME_ZONE));
        URI uri = request.getResourceUrl();
        String hostHeader = uri.getHost();
        if (!RequestUtils.isDefaultPort(uri)) {
            hostHeader = hostHeader + ":" + uri.getPort();
        }
        request.getHeaders().set(HOST_HEADER, hostHeader);
        String timestamp = timestampFormat.format(date);
        String dateStamp = dateFormat.format(date);
        request.getHeaders().set(STORMAPTH_DATE_HEADER, timestamp);
        String method = request.getMethod().toString();
        String canonicalResourcePath = this.canonicalizeResourcePath(uri.getPath());
        String canonicalQueryString = this.canonicalizeQueryString(request);
        String canonicalHeadersString = this.canonicalizeHeadersString(request);
        String signedHeadersString = this.getSignedHeadersString(request);
        String requestPayloadHashHex = Sauthc1Signer.toHex(this.hash(this.getRequestPayload(request)));
        String canonicalRequest = method + NL + canonicalResourcePath + NL + canonicalQueryString + NL + canonicalHeadersString + NL + signedHeadersString + NL + requestPayloadHashHex;
        log.debug("{} Canonical Request: {}", (Object)AUTHENTICATION_SCHEME, (Object)canonicalRequest);
        String id = apiKey.getId() + "/" + dateStamp + "/" + nonce + "/" + ID_TERMINATOR;
        String canonicalRequestHashHex = Sauthc1Signer.toHex(this.hash(canonicalRequest));
        String stringToSign = "HMAC-SHA-256\n" + timestamp + NL + id + NL + canonicalRequestHashHex;
        log.debug("{} String to Sign: {}", (Object)AUTHENTICATION_SCHEME, (Object)stringToSign);
        byte[] kSecret = Sauthc1Signer.toUtf8Bytes(AUTHENTICATION_SCHEME + apiKey.getSecret());
        byte[] kDate = this.sign(dateStamp, kSecret, MacAlgorithm.HmacSHA256);
        byte[] kNonce = this.sign(nonce, kDate, MacAlgorithm.HmacSHA256);
        byte[] kSigning = this.sign(ID_TERMINATOR, kNonce, MacAlgorithm.HmacSHA256);
        byte[] signature = this.sign(Sauthc1Signer.toUtf8Bytes(stringToSign), kSigning, MacAlgorithm.HmacSHA256);
        String signatureHex = Sauthc1Signer.toHex(signature);
        String authorizationHeader = "SAuthc1 " + Sauthc1Signer.createNameValuePair(SAUTHC1_ID, id) + ", " + Sauthc1Signer.createNameValuePair(SAUTHC1_SIGNED_HEADERS, signedHeadersString) + ", " + Sauthc1Signer.createNameValuePair(SAUTHC1_SIGNATURE, signatureHex);
        log.debug("{}: {}", (Object)AUTHORIZATION_HEADER, (Object)authorizationHeader);
        request.getHeaders().set(AUTHORIZATION_HEADER, authorizationHeader);
    }

    private static String createNameValuePair(String name, String value) {
        return name + "=" + value;
    }

    public static byte[] toUtf8Bytes(String s) {
        if (s == null) {
            return null;
        }
        try {
            return s.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to UTF-8 encode!", e);
        }
    }

    public static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i]);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    protected byte[] hash(String text) throws SignatureException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(DEFAULT_ENCODING));
            return md.digest();
        }
        catch (Exception e) {
            throw new SignatureException("Unable to compute hash while signing request.", e);
        }
    }

    protected byte[] sign(String stringData, byte[] key, MacAlgorithm algorithm) throws SignatureException {
        try {
            byte[] data = stringData.getBytes(DEFAULT_ENCODING);
            return this.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new SignatureException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected byte[] sign(byte[] data, byte[] key, MacAlgorithm algorithm) throws SignatureException {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new SignatureException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected String getRequestPayload(Request request) {
        return this.getRequestPayloadWithoutQueryParams(request);
    }

    protected String getRequestPayloadWithoutQueryParams(Request request) {
        try {
            String string;
            InputStream content = request.getBody();
            if (content == null) {
                return "";
            }
            if (content instanceof StringInputStream) {
                return content.toString();
            }
            if (!content.markSupported()) {
                throw new SignatureException("Unable to read request payload to sign request (mark not supported).");
            }
            content.mark(-1);
            try {
                string = new Scanner(content, DEFAULT_ENCODING).useDelimiter("\\A").next();
            }
            catch (NoSuchElementException nsee) {
                string = "";
            }
            content.reset();
            return string;
        }
        catch (Exception e) {
            throw new SignatureException("Unable to read request payload to sign request: " + e.getMessage(), e);
        }
    }

    protected String canonicalizeQueryString(Request request) {
        return request.getQueryString().toString(true);
    }

    private String canonicalizeResourcePath(String resourcePath) {
        if (resourcePath == null || resourcePath.length() == 0) {
            return "/";
        }
        return RequestUtils.encodeUrl(resourcePath, true, true);
    }

    private String canonicalizeHeadersString(Request request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            buffer.append(header.toLowerCase()).append(":");
            Object values = request.getHeaders().get(header);
            boolean first = true;
            if (values != null) {
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    String value = (String)i$.next();
                    if (!first) {
                        buffer.append(",");
                    }
                    buffer.append(value);
                    first = false;
                }
            }
            buffer.append(NL);
        }
        return buffer.toString();
    }

    private String getSignedHeadersString(Request request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(header.toLowerCase());
        }
        return buffer.toString();
    }
}

