/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.resource;

import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.BooleanProperty;
import com.stormpath.sdk.impl.resource.DateProperty;
import com.stormpath.sdk.impl.resource.IntegerProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ReferenceFactory;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.resource.Resource;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.codehaus.jackson.map.util.ISO8601DateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResource
implements Resource {
    private static final Logger log = LoggerFactory.getLogger(AbstractResource.class);
    private static final DateFormat dateFormatter = new ISO8601DateFormat();
    public static final String HREF_PROP_NAME = "href";
    protected final Map<String, Object> properties;
    protected final Map<String, Object> dirtyProperties;
    protected final Set<String> deletedPropertyNames;
    private final InternalDataStore dataStore;
    protected final Lock readLock;
    protected final Lock writeLock;
    private volatile boolean materialized;
    protected volatile boolean dirty;
    protected final ReferenceFactory referenceFactory = new ReferenceFactory();

    protected AbstractResource(InternalDataStore dataStore) {
        this(dataStore, null);
    }

    protected AbstractResource(InternalDataStore dataStore, Map<String, Object> properties) {
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = rwl.readLock();
        this.writeLock = rwl.writeLock();
        this.dataStore = dataStore;
        this.properties = new LinkedHashMap<String, Object>();
        this.dirtyProperties = new LinkedHashMap<String, Object>();
        this.deletedPropertyNames = new HashSet<String>();
        this.setProperties(properties);
    }

    protected static Map<String, Property> createPropertyDescriptorMap(Property ... props) {
        LinkedHashMap<String, Property> m = new LinkedHashMap<String, Property>();
        for (Property prop : props) {
            m.put(prop.getName(), prop);
        }
        return m;
    }

    public abstract Map<String, Property> getPropertyDescriptors();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setProperties(Map<String, Object> properties) {
        this.writeLock.lock();
        try {
            this.properties.clear();
            this.dirtyProperties.clear();
            this.dirty = false;
            if (properties != null && !properties.isEmpty()) {
                this.properties.putAll(properties);
                boolean hrefOnly = this.properties.size() == 1 && this.properties.containsKey(HREF_PROP_NAME);
                this.materialized = !hrefOnly;
            } else {
                this.materialized = false;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getHref() {
        return this.getStringProperty(HREF_PROP_NAME);
    }

    protected final InternalDataStore getDataStore() {
        return this.dataStore;
    }

    protected final boolean isMaterialized() {
        return this.materialized;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    protected final boolean isNew() {
        Object prop = this.readProperty(HREF_PROP_NAME);
        if (prop == null) {
            return true;
        }
        String href = String.valueOf(prop);
        return !Strings.hasText((String)href);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void materialize() {
        AbstractResource resource = (AbstractResource)this.dataStore.getResource(this.getHref(), this.getClass());
        this.writeLock.lock();
        try {
            this.properties.clear();
            this.properties.putAll(resource.properties);
            this.properties.putAll(this.dirtyProperties);
            this.materialized = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPropertyNames() {
        this.readLock.lock();
        try {
            Set<String> keys = this.properties.keySet();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(keys);
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUpdatedPropertyNames() {
        this.readLock.lock();
        try {
            Set<String> keys = this.dirtyProperties.keySet();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(keys);
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getDeletedPropertyNames() {
        this.readLock.lock();
        try {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.deletedPropertyNames);
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        if (!(HREF_PROP_NAME.equals(name) || this.isNew() || this.isMaterialized())) {
            boolean present = false;
            this.readLock.lock();
            try {
                present = this.dirtyProperties.containsKey(name);
            }
            finally {
                this.readLock.unlock();
            }
            if (!present) {
                this.materialize();
            }
        }
        return this.readProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readProperty(String name) {
        this.readLock.lock();
        try {
            Object object = this.properties.get(name);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void setProperty(Property property, Object value) {
        this.setProperty(property.getName(), value, true);
    }

    protected void setProperty(String name, Object value) {
        this.setProperty(name, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object setProperty(String name, Object value, boolean dirty) {
        Object previous;
        this.writeLock.lock();
        try {
            previous = this.properties.put(name, value);
            if (dirty) {
                this.dirtyProperties.put(name, value);
                this.dirty = true;
            }
            if (this.deletedPropertyNames.contains(name)) {
                this.deletedPropertyNames.remove(name);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return previous;
    }

    protected String getString(StringProperty property) {
        return this.getStringProperty(property.getName());
    }

    protected String getStringProperty(String key) {
        Object value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    protected Date getDateProperty(DateProperty key) {
        Object value = this.getProperty(key.getName());
        if (value == null) {
            return null;
        }
        try {
            return dateFormatter.parse(String.valueOf(value));
        }
        catch (ParseException e) {
            if (log.isErrorEnabled()) {
                String msg = "Unabled to parse string '{}' into an date value.  Defaulting to null.";
                log.error(msg, (Throwable)e);
            }
            return null;
        }
    }

    protected int getInt(IntegerProperty property) {
        return this.getIntProperty(property.getName());
    }

    protected int getIntProperty(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof String) {
                return this.parseInt((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
        }
        return -1;
    }

    protected boolean getBoolean(BooleanProperty property) {
        return this.getBooleanProperty(property.getName());
    }

    protected boolean getBooleanProperty(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
        }
        return Boolean.FALSE;
    }

    protected <T extends Resource> T getResourceProperty(ResourceReference<T> property) {
        String key = property.getName();
        Class clazz = property.getType();
        Object value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (clazz.isInstance(value)) {
            return (T)((Resource)value);
        }
        if (value instanceof Map && !((Map)value).isEmpty()) {
            Object resource = this.dataStore.instantiate(clazz, (Map)value);
            this.setProperty(key, resource, false);
            return resource;
        }
        String msg = "'" + key + "' property value type does not match the specified type.  Specified type: " + clazz.getName() + ".  Existing type: " + value.getClass().getName();
        msg = msg + (this.isPrintableProperty(key) ? ".  Value: " + value : ".");
        throw new IllegalArgumentException(msg);
    }

    protected <T extends Resource> void setResourceProperty(ResourceReference<T> property, Resource value) {
        Assert.notNull(property, (String)"Property argument cannot be null.");
        String name = property.getName();
        Map<String, String> reference = this.referenceFactory.createReference(name, value);
        this.setProperty(name, reference);
    }

    private int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (log.isErrorEnabled()) {
                String msg = "Unabled to parse string '{}' into an integer value.  Defaulting to -1";
                log.error(msg, (Throwable)e);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                String key;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (!this.isPrintableProperty(key = entry.getKey())) continue;
                sb.append(key).append(": ").append(String.valueOf(entry.getValue()));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected boolean isPrintableProperty(String name) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.properties.isEmpty() ? 0 : this.properties.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractResource other = (AbstractResource)o;
        this.readLock.lock();
        try {
            other.readLock.lock();
            try {
                boolean bl = this.properties.equals(other.properties);
                other.readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                other.readLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }
}

