/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountOptions;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.account.EmailVerificationToken;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyCriteria;
import com.stormpath.sdk.api.ApiKeyList;
import com.stormpath.sdk.api.ApiKeyOptions;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationCriteria;
import com.stormpath.sdk.application.ApplicationList;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.group.GroupMembership;
import com.stormpath.sdk.group.GroupMembershipList;
import com.stormpath.sdk.group.Groups;
import com.stormpath.sdk.impl.api.DefaultApiKey;
import com.stormpath.sdk.impl.api.DefaultApiKeyOptions;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.group.DefaultGroupMembership;
import com.stormpath.sdk.impl.provider.IdentityProviderType;
import com.stormpath.sdk.impl.resource.AbstractExtendableInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.oauth.AccessToken;
import com.stormpath.sdk.oauth.AccessTokenList;
import com.stormpath.sdk.oauth.RefreshToken;
import com.stormpath.sdk.oauth.RefreshTokenList;
import com.stormpath.sdk.provider.ProviderData;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Criterion;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Map;

public class DefaultAccount
extends AbstractExtendableInstanceResource
implements Account {
    static final StringProperty EMAIL = new StringProperty("email");
    static final StringProperty USERNAME = new StringProperty("username");
    public static final StringProperty PASSWORD = new StringProperty("password");
    static final StringProperty GIVEN_NAME = new StringProperty("givenName");
    static final StringProperty MIDDLE_NAME = new StringProperty("middleName");
    static final StringProperty SURNAME = new StringProperty("surname");
    static final StatusProperty<AccountStatus> STATUS = new StatusProperty<AccountStatus>(AccountStatus.class);
    static final StringProperty FULL_NAME = new StringProperty("fullName");
    static final ResourceReference<EmailVerificationToken> EMAIL_VERIFICATION_TOKEN = new ResourceReference<EmailVerificationToken>("emailVerificationToken", EmailVerificationToken.class);
    static final ResourceReference<Directory> DIRECTORY = new ResourceReference<Directory>("directory", Directory.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final ResourceReference<ProviderData> PROVIDER_DATA = new ResourceReference<ProviderData>("providerData", ProviderData.class);
    static final CollectionReference<GroupList, Group> GROUPS = new CollectionReference<GroupList, Group>("groups", GroupList.class, Group.class);
    static final CollectionReference<GroupMembershipList, GroupMembership> GROUP_MEMBERSHIPS = new CollectionReference<GroupMembershipList, GroupMembership>("groupMemberships", GroupMembershipList.class, GroupMembership.class);
    static final CollectionReference<ApiKeyList, ApiKey> API_KEYS = new CollectionReference<ApiKeyList, ApiKey>("apiKeys", ApiKeyList.class, ApiKey.class);
    static final CollectionReference<ApplicationList, Application> APPLICATIONS = new CollectionReference<ApplicationList, Application>("applications", ApplicationList.class, Application.class);
    static final CollectionReference<AccessTokenList, AccessToken> ACCESS_TOKENS = new CollectionReference<AccessTokenList, AccessToken>("accessTokens", AccessTokenList.class, AccessToken.class);
    static final CollectionReference<RefreshTokenList, RefreshToken> REFRESH_TOKENS = new CollectionReference<RefreshTokenList, RefreshToken>("refreshTokens", RefreshTokenList.class, RefreshToken.class);
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultAccount.createPropertyDescriptorMap(USERNAME, EMAIL, PASSWORD, GIVEN_NAME, MIDDLE_NAME, SURNAME, STATUS, FULL_NAME, EMAIL_VERIFICATION_TOKEN, CUSTOM_DATA, DIRECTORY, TENANT, GROUPS, GROUP_MEMBERSHIPS, PROVIDER_DATA, API_KEYS, APPLICATIONS, ACCESS_TOKENS, REFRESH_TOKENS);

    public DefaultAccount(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAccount(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    protected boolean isPrintableProperty(String name) {
        return !PASSWORD.getName().equalsIgnoreCase(name);
    }

    public String getUsername() {
        return this.getString(USERNAME);
    }

    public Account setUsername(String username) {
        this.setProperty(USERNAME, (Object)username);
        return this;
    }

    public String getEmail() {
        return this.getString(EMAIL);
    }

    public Account setEmail(String email) {
        this.setProperty(EMAIL, (Object)email);
        return this;
    }

    public Account setPassword(String password) {
        this.setProperty(PASSWORD, (Object)password);
        return this;
    }

    public String getGivenName() {
        return this.getString(GIVEN_NAME);
    }

    public Account setGivenName(String givenName) {
        this.setProperty(GIVEN_NAME, (Object)givenName);
        return this;
    }

    public String getMiddleName() {
        return this.getString(MIDDLE_NAME);
    }

    public Account setMiddleName(String middleName) {
        this.setProperty(MIDDLE_NAME, (Object)middleName);
        return this;
    }

    public String getSurname() {
        return this.getString(SURNAME);
    }

    public Account setSurname(String surname) {
        this.setProperty(SURNAME, (Object)surname);
        return this;
    }

    public String getFullName() {
        return this.getString(FULL_NAME);
    }

    public AccountStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return AccountStatus.valueOf((String)value.toUpperCase());
    }

    public Account setStatus(AccountStatus status) {
        this.setProperty(STATUS, (Object)status.name());
        return this;
    }

    public GroupList getGroups() {
        return (GroupList)this.getResourceProperty(GROUPS);
    }

    public GroupList getGroups(Map<String, Object> queryParams) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, queryParams);
    }

    public GroupList getGroups(GroupCriteria criteria) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, (Criteria)criteria);
    }

    public Directory getDirectory() {
        return this.getResourceProperty(DIRECTORY);
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public GroupMembershipList getGroupMemberships() {
        return (GroupMembershipList)this.getResourceProperty(GROUP_MEMBERSHIPS);
    }

    public GroupMembership addGroup(Group group) {
        return DefaultGroupMembership.create(this, group, this.getDataStore());
    }

    public GroupMembership addGroup(String hrefOrName) {
        Assert.hasText((String)hrefOrName, (String)"hrefOrName cannot be null or empty");
        Group group = this.findGroupInDirectory(hrefOrName, this.getDirectory());
        if (group != null) {
            return DefaultGroupMembership.create(this, group, this.getDataStore());
        }
        throw new IllegalStateException("The specified group was not found in this Account's directory.");
    }

    public Account removeGroup(Group group) {
        Assert.notNull((Object)group, (String)"group cannot be null");
        GroupMembership groupMembership = null;
        for (GroupMembership aGroupMembership : this.getGroupMemberships()) {
            if (!aGroupMembership.getGroup().getHref().equals(group.getHref())) continue;
            groupMembership = aGroupMembership;
            break;
        }
        if (groupMembership == null) {
            throw new IllegalStateException("This account does not belong to the specified group.");
        }
        groupMembership.delete();
        return this;
    }

    public Account removeGroup(String hrefOrName) {
        GroupMembership groupMembership = null;
        for (GroupMembership aGroupMembership : this.getGroupMemberships()) {
            if (!aGroupMembership.getGroup().getName().equals(hrefOrName) && !aGroupMembership.getGroup().getHref().equals(hrefOrName)) continue;
            groupMembership = aGroupMembership;
            break;
        }
        if (groupMembership == null) {
            throw new IllegalStateException("This account does not belong to the specified group.");
        }
        groupMembership.delete();
        return this;
    }

    public EmailVerificationToken getEmailVerificationToken() {
        return this.getResourceProperty(EMAIL_VERIFICATION_TOKEN);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public Account saveWithResponseOptions(AccountOptions accountOptions) {
        Assert.notNull((Object)accountOptions, (String)"accountOptions can't be null.");
        this.applyCustomDataUpdatesIfNecessary();
        this.getDataStore().save(this, (Options)accountOptions);
        return this;
    }

    public boolean isMemberOfGroup(String hrefOrName) {
        if (!Strings.hasText((String)hrefOrName)) {
            return false;
        }
        for (Group aGroup : this.getGroups()) {
            if (!aGroup.getName().equalsIgnoreCase(hrefOrName) && !aGroup.getHref().equalsIgnoreCase(hrefOrName)) continue;
            return true;
        }
        return false;
    }

    public ApiKeyList getApiKeys() {
        return (ApiKeyList)this.getResourceProperty(API_KEYS);
    }

    public ProviderData getProviderData() {
        Object value = this.getProperty(PROVIDER_DATA.getName());
        if (ProviderData.class.isInstance(value) || value == null) {
            return (ProviderData)value;
        }
        if (value instanceof Map && !((Map)value).isEmpty()) {
            String href = (String)((Map)value).get("href");
            if (href == null) {
                throw new IllegalStateException("providerData resource does not contain its required href property.");
            }
            ProviderData providerData = (ProviderData)this.getDataStore().getResource(href, ProviderData.class, "providerId", IdentityProviderType.IDENTITY_PROVIDERDATA_CLASS_MAP);
            this.setProperty(PROVIDER_DATA, (Object)providerData);
            return providerData;
        }
        String msg = "'" + PROVIDER_DATA.getName() + "' property value type does not match the specified type. Specified type: " + PROVIDER_DATA.getType() + ".  Existing type: " + value.getClass().getName() + ".  Value: " + value;
        throw new IllegalStateException(msg);
    }

    public ApiKeyList getApiKeys(Map<String, Object> queryParams) {
        ApiKeyList list = this.getApiKeys();
        return this.getDataStore().getResource(list.getHref(), ApiKeyList.class, queryParams);
    }

    public ApiKeyList getApiKeys(ApiKeyCriteria criteria) {
        ApiKeyList list = this.getApiKeys();
        return this.getDataStore().getResource(list.getHref(), ApiKeyList.class, (Criteria)criteria);
    }

    public ApiKey createApiKey() {
        return this.createApiKey(new DefaultApiKeyOptions());
    }

    public ApiKey createApiKey(ApiKeyOptions options) {
        Assert.notNull((Object)options, (String)"options argument cannot be null.");
        String href = this.getApiKeys().getHref();
        return this.getDataStore().create(href, new DefaultApiKey(this.getDataStore()), (Options)options);
    }

    public ApplicationList getApplications() {
        return (ApplicationList)this.getResourceProperty(APPLICATIONS);
    }

    public ApplicationList getApplications(Map<String, Object> queryParams) {
        ApplicationList proxy = this.getApplications();
        return this.getDataStore().getResource(proxy.getHref(), ApplicationList.class, queryParams);
    }

    public ApplicationList getApplications(ApplicationCriteria criteria) {
        ApplicationList proxy = this.getApplications();
        return this.getDataStore().getResource(proxy.getHref(), ApplicationList.class, (Criteria)criteria);
    }

    private Group findGroupInDirectory(String hrefOrName, Directory directory) {
        GroupList groups;
        Assert.hasText((String)hrefOrName, (String)"hrefOrName cannot be null or empty");
        Assert.notNull((Object)directory, (String)"directory cannot be null");
        Group group = null;
        String[] splitHrefOrName = hrefOrName.split("/");
        if (splitHrefOrName.length > 4) {
            try {
                group = (Group)this.getDataStore().getResource(hrefOrName, Group.class);
                if (group != null && group.getDirectory().getHref().equals(directory.getHref())) {
                    return group;
                }
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }
        if ((groups = directory.getGroups(Groups.where((Criterion)Groups.name().eqIgnoreCase(hrefOrName)))).iterator().hasNext()) {
            group = (Group)groups.iterator().next();
        }
        return group;
    }

    public AccessTokenList getAccessTokens() {
        return (AccessTokenList)this.getResourceProperty(ACCESS_TOKENS);
    }

    public RefreshTokenList getRefreshTokens() {
        return (RefreshTokenList)this.getResourceProperty(REFRESH_TOKENS);
    }
}

