/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountOptions;
import com.stormpath.sdk.account.CreateAccountRequest;
import com.stormpath.sdk.account.PasswordFormat;
import com.stormpath.sdk.lang.Assert;

public class DefaultCreateAccountRequest
implements CreateAccountRequest {
    private final Account account;
    private final Boolean registrationWorkflowEnabled;
    private final AccountOptions options;
    private PasswordFormat passwordFormat;

    public DefaultCreateAccountRequest(Account account, Boolean registrationWorkflowEnabled, AccountOptions options) {
        Assert.notNull((Object)account, (String)"Account cannot be null.");
        this.account = account;
        this.registrationWorkflowEnabled = registrationWorkflowEnabled;
        this.options = options;
    }

    public Account getAccount() {
        return this.account;
    }

    public boolean isRegistrationWorkflowOptionSpecified() {
        return this.registrationWorkflowEnabled != null;
    }

    public boolean isPasswordFormatSpecified() {
        return this.passwordFormat != null;
    }

    public CreateAccountRequest setPasswordFormat(PasswordFormat passwordFormat) {
        this.passwordFormat = passwordFormat;
        return this;
    }

    public PasswordFormat getPasswordFormat() {
        if (this.passwordFormat == null) {
            throw new IllegalStateException("passwordFormat has not been specified.");
        }
        return this.passwordFormat;
    }

    public boolean isRegistrationWorkflowEnabled() throws IllegalStateException {
        if (this.registrationWorkflowEnabled == null) {
            throw new IllegalStateException("registrationWorkflowEnabled has not been configured. Use the isRegistrationWorkflowOptionSpecified method to check first before invoking this method.");
        }
        return this.registrationWorkflowEnabled;
    }

    public boolean isAccountOptionsSpecified() {
        return this.options != null;
    }

    public AccountOptions getAccountOptions() {
        if (this.options == null) {
            throw new IllegalStateException("accountOptions has not been configured. Use the isAccountOptionsSpecified method to check first before invoking this method.");
        }
        return this.options;
    }
}

