/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.account;

import com.stormpath.sdk.account.VerificationEmailRequest;
import com.stormpath.sdk.account.VerificationEmailRequestBuilder;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.impl.account.DefaultVerificationEmailRequest;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;

public class DefaultVerificationEmailRequestBuilder
implements VerificationEmailRequestBuilder {
    private String login;
    private AccountStore accountStore;

    public VerificationEmailRequestBuilder setLogin(String usernameOrEmail) {
        Assert.hasText((String)usernameOrEmail, (String)"usernameOrEmail cannot be null or empty.");
        this.login = usernameOrEmail;
        return this;
    }

    public VerificationEmailRequestBuilder setAccountStore(AccountStore accountStore) {
        if (accountStore != null && accountStore.getHref() == null) {
            throw new IllegalArgumentException("accountStore has been specified but its href is null.");
        }
        this.accountStore = accountStore;
        return this;
    }

    public VerificationEmailRequest build() {
        Assert.state((boolean)Strings.hasText((String)this.login), (String)"login is a required property. It must be provided before building.");
        DefaultVerificationEmailRequest verificationEmailRequest = new DefaultVerificationEmailRequest(null);
        verificationEmailRequest.setLogin(this.login);
        if (this.accountStore != null) {
            verificationEmailRequest.setAccountStore(this.accountStore);
        }
        return verificationEmailRequest;
    }
}

