/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.api;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyBuilder;
import com.stormpath.sdk.impl.api.ClientApiKey;
import com.stormpath.sdk.impl.io.DefaultResourceFactory;
import com.stormpath.sdk.impl.io.ResourceFactory;
import com.stormpath.sdk.lang.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientApiKeyBuilder
implements ApiKeyBuilder {
    private static final Logger log = LoggerFactory.getLogger(ClientApiKeyBuilder.class);
    public static final String DEFAULT_API_KEY_PROPERTIES_FILE_LOCATION = System.getProperty("user.home") + File.separatorChar + ".stormpath" + File.separatorChar + "apiKey.properties";
    private String apiKeyId;
    private String apiKeySecret;
    private String apiKeyFileLocation;
    private InputStream apiKeyInputStream;
    private Reader apiKeyReader;
    private Properties apiKeyProperties;
    private String apiKeyIdPropertyName = "apiKey.id";
    private String apiKeySecretPropertyName = "apiKey.secret";
    private ResourceFactory resourceFactory = new DefaultResourceFactory();

    public ApiKeyBuilder setId(String id) {
        this.apiKeyId = id;
        return this;
    }

    public ApiKeyBuilder setSecret(String secret) {
        this.apiKeySecret = secret;
        return this;
    }

    public ApiKeyBuilder setProperties(Properties properties) {
        this.apiKeyProperties = properties;
        return this;
    }

    public ApiKeyBuilder setReader(Reader reader) {
        this.apiKeyReader = reader;
        return this;
    }

    public ApiKeyBuilder setInputStream(InputStream is) {
        this.apiKeyInputStream = is;
        return this;
    }

    public ApiKeyBuilder setFileLocation(String location) {
        this.apiKeyFileLocation = location;
        return this;
    }

    public ApiKeyBuilder setIdPropertyName(String idPropertyName) {
        this.apiKeyIdPropertyName = idPropertyName;
        return this;
    }

    public ApiKeyBuilder setSecretPropertyName(String secretPropertyName) {
        this.apiKeySecretPropertyName = secretPropertyName;
        return this;
    }

    protected Properties getDefaultApiKeyFileProperties() {
        Properties props = new Properties();
        try {
            Reader reader = this.createFileReader(DEFAULT_API_KEY_PROPERTIES_FILE_LOCATION);
            props = ClientApiKeyBuilder.toProperties(reader);
        }
        catch (IOException ignored) {
            log.debug("Unable to find or load default api key properties file [{}]. This can be safely ignored as this is a fallback location - other more specific locations will be checked.", (Object)DEFAULT_API_KEY_PROPERTIES_FILE_LOCATION, (Object)ignored);
        }
        return props;
    }

    protected Properties getEnvironmentVariableFileProperties() {
        Properties props = new Properties();
        String location = System.getenv("STORMPATH_API_KEY_FILE");
        if (Strings.hasText((String)location)) {
            try {
                Reader reader = this.createFileReader(location);
                props = ClientApiKeyBuilder.toProperties(reader);
            }
            catch (IOException ignored) {
                log.debug("Unable to load api key properties file [{}] specified by environment variable STORMPATH_API_KEY_FILE. This can be safely ignored as this is a fallback location - other more specific locations will be checked.", (Object)location, (Object)ignored);
            }
        }
        return props;
    }

    protected Properties getSystemPropertyFileProperties() {
        Properties props = new Properties();
        String location = System.getProperty("stormpath.client.apiKey.file");
        if (Strings.hasText((String)location)) {
            try {
                Reader reader = this.createFileReader(location);
                props = ClientApiKeyBuilder.toProperties(reader);
            }
            catch (IOException ignored) {
                log.debug("Unable to load api key properties file [{}] specified by system property stormpath.client.apiKey.file. This can be safely ignored as this is a fallback location - other more specific locations will be checked.", (Object)location, (Object)ignored);
            }
        }
        return props;
    }

    protected Properties getEnvironmentVariableProperties() {
        Properties props = new Properties();
        String value = System.getenv("STORMPATH_API_KEY_ID");
        if (Strings.hasText((String)value)) {
            props.put(this.apiKeyIdPropertyName, value);
        }
        if (Strings.hasText((String)(value = System.getenv("STORMPATH_API_KEY_SECRET")))) {
            props.put(this.apiKeySecretPropertyName, value);
        }
        return props;
    }

    protected Properties getSystemProperties() {
        Properties props = new Properties();
        String value = System.getProperty("stormpath.client.apiKey.id");
        if (Strings.hasText((String)value)) {
            props.put(this.apiKeyIdPropertyName, value);
        }
        if (Strings.hasText((String)(value = System.getProperty("stormpath.client.apiKey.secret")))) {
            props.put(this.apiKeySecretPropertyName, value);
        }
        return props;
    }

    public ApiKey build() {
        String msg;
        Reader reader;
        Properties props = this.getDefaultApiKeyFileProperties();
        String id = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeyIdPropertyName);
        String secret = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeySecretPropertyName);
        props = this.getEnvironmentVariableFileProperties();
        id = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeyIdPropertyName, id);
        secret = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeySecretPropertyName, secret);
        props = this.getEnvironmentVariableProperties();
        id = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeyIdPropertyName, id);
        secret = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeySecretPropertyName, secret);
        props = this.getSystemPropertyFileProperties();
        id = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeyIdPropertyName, id);
        secret = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeySecretPropertyName, secret);
        props = this.getSystemProperties();
        id = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeyIdPropertyName, id);
        secret = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeySecretPropertyName, secret);
        if (Strings.hasText((String)this.apiKeyFileLocation)) {
            try {
                reader = this.createFileReader(this.apiKeyFileLocation);
                props = ClientApiKeyBuilder.toProperties(reader);
            }
            catch (IOException e) {
                String msg2 = "Unable to read properties from specified apiKeyFileLocation [" + this.apiKeyFileLocation + "].";
                throw new IllegalArgumentException(msg2, e);
            }
            id = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeyIdPropertyName, id);
            secret = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeySecretPropertyName, secret);
        }
        if (this.apiKeyInputStream != null) {
            try {
                reader = ClientApiKeyBuilder.toReader(this.apiKeyInputStream);
                props = ClientApiKeyBuilder.toProperties(reader);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read properties from specified apiKeyInputStream.", e);
            }
            id = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeyIdPropertyName, id);
            secret = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeySecretPropertyName, secret);
        }
        if (this.apiKeyReader != null) {
            try {
                props = ClientApiKeyBuilder.toProperties(this.apiKeyReader);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read properties from specified apiKeyReader.", e);
            }
            id = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeyIdPropertyName, id);
            secret = ClientApiKeyBuilder.getPropertyValue(props, this.apiKeySecretPropertyName, secret);
        }
        if (this.apiKeyProperties != null && !this.apiKeyProperties.isEmpty()) {
            id = ClientApiKeyBuilder.getPropertyValue(this.apiKeyProperties, this.apiKeyIdPropertyName, id);
            secret = ClientApiKeyBuilder.getPropertyValue(this.apiKeyProperties, this.apiKeySecretPropertyName, secret);
        }
        id = ClientApiKeyBuilder.valueOf(this.apiKeyId, id);
        secret = ClientApiKeyBuilder.valueOf(this.apiKeySecret, secret);
        if (!Strings.hasText((String)id)) {
            msg = "Unable to find an API Key 'id', either from explicit configuration (for example, " + ApiKeyBuilder.class.getSimpleName() + ".setApiKeyId) or from fallback locations:\n\n" + "1) system property stormpath.client.apiKey.id\n" + "2) resource file path or URL specified by system property stormpath.client.apiKey.file\n" + "3) resource file path or URL specified by environment variable STORMPATH_API_KEY_FILE\n" + "4) environment variable STORMPATH_API_KEY_ID\n" + "5) default apiKey.properties file location " + DEFAULT_API_KEY_PROPERTIES_FILE_LOCATION + ".\n\n" + "Please ensure you manually configure an API Key ID or ensure that it exists in one of these " + "fallback locations.";
            throw new IllegalStateException(msg);
        }
        if (!Strings.hasText((String)secret)) {
            msg = "Unable to find an API Key 'secret', either from explicit configuration (for example, " + ApiKeyBuilder.class.getSimpleName() + ".setApiKeySecret) or from fallback locations:\n\n" + "1) system property stormpath.client.apiKey.secret\n" + "2) resource file path or URL specified by system property stormpath.client.apiKey.file\n" + "3) resource file path or URL specified by environment variable STORMPATH_API_KEY_FILE\n" + "4) environment variable STORMPATH_API_KEY_SECRET\n" + "5) default apiKey.properties file location " + DEFAULT_API_KEY_PROPERTIES_FILE_LOCATION + ".\n\n" + "Please ensure you manually configure an API Key Secret or ensure that it exists in one of " + "these fallback locations.";
            throw new IllegalStateException(msg);
        }
        return this.createApiKey(id, secret);
    }

    protected ApiKey createApiKey(String id, String secret) {
        return new ClientApiKey(id, secret);
    }

    private static String getPropertyValue(Properties properties, String propName) {
        String value = properties.getProperty(propName);
        if (value != null && "".equals(value = value.trim())) {
            value = null;
        }
        return value;
    }

    private static String valueOf(String discoveredValue, String defaultValue) {
        if (!Strings.hasText((String)discoveredValue)) {
            return defaultValue;
        }
        return discoveredValue;
    }

    private static String getPropertyValue(Properties properties, String propName, String defaultValue) {
        String value = ClientApiKeyBuilder.getPropertyValue(properties, propName);
        return ClientApiKeyBuilder.valueOf(value, defaultValue);
    }

    protected Reader createFileReader(String apiKeyFileLocation) throws IOException {
        InputStream is = this.resourceFactory.createResource(apiKeyFileLocation).getInputStream();
        return ClientApiKeyBuilder.toReader(is);
    }

    private static Reader toReader(InputStream is) throws IOException {
        return new InputStreamReader(is, "ISO-8859-1");
    }

    private static Properties toProperties(Reader reader) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }
}

