/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.application;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.account.Accounts;
import com.stormpath.sdk.account.CreateAccountRequest;
import com.stormpath.sdk.account.PasswordResetToken;
import com.stormpath.sdk.account.VerificationEmailRequest;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyList;
import com.stormpath.sdk.api.ApiKeyOptions;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationAccountStoreMapping;
import com.stormpath.sdk.application.ApplicationAccountStoreMappingCriteria;
import com.stormpath.sdk.application.ApplicationAccountStoreMappingList;
import com.stormpath.sdk.application.ApplicationOptions;
import com.stormpath.sdk.application.ApplicationStatus;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.Directories;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.directory.DirectoryCriteria;
import com.stormpath.sdk.directory.DirectoryList;
import com.stormpath.sdk.group.CreateGroupRequest;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.group.Groups;
import com.stormpath.sdk.http.HttpRequest;
import com.stormpath.sdk.idsite.IdSiteCallbackHandler;
import com.stormpath.sdk.idsite.IdSiteUrlBuilder;
import com.stormpath.sdk.impl.account.DefaultPasswordResetToken;
import com.stormpath.sdk.impl.account.DefaultVerificationEmailRequest;
import com.stormpath.sdk.impl.api.ApiKeyParameter;
import com.stormpath.sdk.impl.api.DefaultApiKeyCriteria;
import com.stormpath.sdk.impl.api.DefaultApiKeyOptions;
import com.stormpath.sdk.impl.application.PasswordResetTokenList;
import com.stormpath.sdk.impl.authc.AuthenticationRequestDispatcher;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.idsite.DefaultIdSiteCallbackHandler;
import com.stormpath.sdk.impl.idsite.DefaultIdSiteUrlBuilder;
import com.stormpath.sdk.impl.oauth.DefaultIdSiteAuthenticator;
import com.stormpath.sdk.impl.oauth.DefaultOAuthBearerRequestAuthenticator;
import com.stormpath.sdk.impl.oauth.DefaultOAuthClientCredentialsGrantRequestAuthenticator;
import com.stormpath.sdk.impl.oauth.DefaultOAuthPasswordGrantRequestAuthenticator;
import com.stormpath.sdk.impl.oauth.DefaultOAuthRefreshTokenRequestAuthenticator;
import com.stormpath.sdk.impl.provider.ProviderAccountResolver;
import com.stormpath.sdk.impl.query.DefaultEqualsExpressionFactory;
import com.stormpath.sdk.impl.query.Expandable;
import com.stormpath.sdk.impl.query.Expansion;
import com.stormpath.sdk.impl.resource.AbstractExtendableInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.ListProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.impl.saml.DefaultSamlCallbackHandler;
import com.stormpath.sdk.impl.saml.DefaultSamlIdpUrlBuilder;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.oauth.IdSiteAuthenticator;
import com.stormpath.sdk.oauth.OAuthApiRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthBearerRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthClientCredentialsGrantRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthPolicy;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthenticator;
import com.stormpath.sdk.organization.Organization;
import com.stormpath.sdk.organization.OrganizationCriteria;
import com.stormpath.sdk.organization.OrganizationList;
import com.stormpath.sdk.provider.ProviderAccountRequest;
import com.stormpath.sdk.provider.ProviderAccountResult;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Criterion;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.saml.SamlCallbackHandler;
import com.stormpath.sdk.saml.SamlIdpUrlBuilder;
import com.stormpath.sdk.saml.SamlPolicy;
import com.stormpath.sdk.tenant.Tenant;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplication
extends AbstractExtendableInstanceResource
implements Application {
    private static final String OAUTH_REQUEST_AUTHENTICATOR_FQCN = "com.stormpath.sdk.impl.oauth.authc.DefaultOAuthRequestAuthenticator";
    private static final String OAUTH_BUILDER_NOT_AVAILABLE_MSG;
    private static final String OAUTH_AUTHENTICATION_REQUEST_DISPATCHER_FQCN = "com.stormpath.sdk.impl.oauth.authc.OAuthAuthenticationRequestDispatcher";
    private static final Class<OAuthApiRequestAuthenticator> OAUTH_AUTHENTICATION_REQUEST_BUILDER_CLASS;
    private static final Class<AuthenticationRequestDispatcher> AUTHENTICATION_REQUEST_DISPATCHER_CLASS;
    private static final String HTTP_SERVLET_REQUEST_FQCN = "javax.servlet.http.HttpServletRequest";
    private static final Set<Class> HTTP_REQUEST_SUPPORTED_CLASSES;
    private static final String HTTP_REQUEST_NOT_SUPPORTED_MSG = "Class [%s] is not one of the supported http requests classes [%s].";
    private static final String INVALID_URI_FORMAT_MSG = "The provided URI does not match a valid URI scheme.";
    private static final Logger log;
    static final StringProperty NAME;
    static final StringProperty DESCRIPTION;
    static final StatusProperty<ApplicationStatus> STATUS;
    static final ResourceReference<Tenant> TENANT;
    static final ResourceReference<ApplicationAccountStoreMapping> DEFAULT_ACCOUNT_STORE_MAPPING;
    static final ResourceReference<ApplicationAccountStoreMapping> DEFAULT_GROUP_STORE_MAPPING;
    static final ResourceReference<OAuthPolicy> OAUTH_POLICY;
    static final ResourceReference<SamlPolicy> SAML_POLICY;
    static final CollectionReference<AccountList, Account> ACCOUNTS;
    static final CollectionReference<GroupList, Group> GROUPS;
    static final CollectionReference<ApplicationAccountStoreMappingList, ApplicationAccountStoreMapping> ACCOUNT_STORE_MAPPINGS;
    static final CollectionReference<PasswordResetTokenList, PasswordResetToken> PASSWORD_RESET_TOKENS;
    static final ListProperty AUTHORIZED_CALLBACK_URIS;
    public static final String AUTHORIZED_CALLBACK_URIS_PROPERTY_NAME = "authorizedCallbackUris";
    static final Map<String, Property> PROPERTY_DESCRIPTORS;

    public DefaultApplication(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultApplication(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public Application setName(String name) {
        this.setProperty(NAME, (Object)name);
        return this;
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public Application setDescription(String description) {
        this.setProperty(DESCRIPTION, (Object)description);
        return this;
    }

    public ApplicationStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return ApplicationStatus.valueOf((String)value.toUpperCase());
    }

    public Application setStatus(ApplicationStatus status) {
        this.setProperty(STATUS, (Object)status.name());
        return this;
    }

    public AccountList getAccounts() {
        return (AccountList)this.getResourceProperty(ACCOUNTS);
    }

    public AccountList getAccounts(Map<String, Object> queryParams) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, queryParams);
    }

    public AccountList getAccounts(AccountCriteria criteria) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, (Criteria)criteria);
    }

    public GroupList getGroups() {
        return (GroupList)this.getResourceProperty(GROUPS);
    }

    public GroupList getGroups(Map<String, Object> queryParams) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, queryParams);
    }

    public GroupList getGroups(GroupCriteria criteria) {
        GroupList groups = this.getGroups();
        return this.getDataStore().getResource(groups.getHref(), GroupList.class, (Criteria)criteria);
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public PasswordResetToken sendPasswordResetEmail(String email) {
        PasswordResetToken token = this.createPasswordResetToken(email, null);
        return token;
    }

    public PasswordResetToken sendPasswordResetEmail(String email, AccountStore accountStore) throws ResourceException {
        PasswordResetToken token = this.createPasswordResetToken(email, accountStore);
        return token;
    }

    private PasswordResetToken createPasswordResetToken(String email, AccountStore accountStore) {
        DefaultPasswordResetToken passwordResetToken = (DefaultPasswordResetToken)this.getDataStore().instantiate(PasswordResetToken.class);
        passwordResetToken.setEmail(email);
        if (accountStore != null) {
            passwordResetToken.setAccountStore(accountStore);
        }
        String href = this.getPasswordResetTokensHref();
        return this.getDataStore().create(href, passwordResetToken);
    }

    private String getPasswordResetTokensHref() {
        Map passwordResetTokensLink = (Map)this.getProperty(PASSWORD_RESET_TOKENS.getName());
        return (String)passwordResetTokensLink.get("href");
    }

    public SamlPolicy getSamlPolicy() {
        return this.getResourceProperty(SAML_POLICY);
    }

    public List<String> getAuthorizedCallbackUris() {
        return new ArrayList<String>(this.getListProperty(AUTHORIZED_CALLBACK_URIS_PROPERTY_NAME));
    }

    public Application setAuthorizedCallbackUris(List<String> authorizedCallbackUris) {
        this.setProperty(AUTHORIZED_CALLBACK_URIS_PROPERTY_NAME, authorizedCallbackUris);
        this.save();
        return this;
    }

    public Application addAuthorizedCallbackUri(String authorizedCallbackUri) {
        this.validateUri(authorizedCallbackUri);
        List<String> authorizedCallbackUris = this.getAuthorizedCallbackUris();
        authorizedCallbackUris.add(authorizedCallbackUri);
        this.setProperty(AUTHORIZED_CALLBACK_URIS_PROPERTY_NAME, authorizedCallbackUris);
        this.save();
        return this;
    }

    public Account verifyPasswordResetToken(String token) {
        String href = this.getPasswordResetTokensHref() + "/" + token;
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(1);
        props.put("href", href);
        PasswordResetToken prToken = this.getDataStore().instantiate(PasswordResetToken.class, props);
        return prToken.getAccount();
    }

    public OAuthPolicy getOAuthPolicy() {
        return this.getResourceProperty(OAUTH_POLICY);
    }

    public Account resetPassword(String passwordResetToken, String newPassword) {
        Assert.hasText((String)passwordResetToken, (String)"passwordResetToken cannot be empty or null.");
        Assert.hasText((String)newPassword, (String)"newPassword cannot be empty or null.");
        String href = this.getPasswordResetTokensHref() + "/" + passwordResetToken;
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(1);
        props.put("href", href);
        DefaultPasswordResetToken instantiatedToken = (DefaultPasswordResetToken)this.getDataStore().instantiate(PasswordResetToken.class, props);
        instantiatedToken.setPassword(newPassword);
        PasswordResetToken createdPasswordResetToken = this.getDataStore().create(href, instantiatedToken, PasswordResetToken.class);
        return createdPasswordResetToken.getAccount();
    }

    public AuthenticationResult authenticateAccount(AuthenticationRequest request) {
        AuthenticationRequestDispatcher dispatcher = (AuthenticationRequestDispatcher)Classes.newInstance(AUTHENTICATION_REQUEST_DISPATCHER_CLASS);
        return dispatcher.authenticate(this.getDataStore(), this, request);
    }

    public ProviderAccountResult getAccount(ProviderAccountRequest request) throws ResourceException {
        return new ProviderAccountResolver(this.getDataStore()).resolveProviderAccount(this.getHref(), request);
    }

    public Group createGroup(Group group) {
        Assert.notNull((Object)group, (String)"Group instance cannot be null.");
        CreateGroupRequest request = Groups.newCreateRequestFor((Group)group).build();
        return this.createGroup(request);
    }

    public Group createGroup(CreateGroupRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Group group = request.getGroup();
        String href = this.getGroups().getHref();
        if (request.isGroupOptionsSpecified()) {
            return this.getDataStore().create(href, group, (Options)request.getGroupOptions());
        }
        return this.getDataStore().create(href, group);
    }

    public Account createAccount(Account account) {
        Assert.notNull((Object)account, (String)"Account instance cannot be null.");
        CreateAccountRequest request = Accounts.newCreateRequestFor((Account)account).build();
        return this.createAccount(request);
    }

    public Account createAccount(CreateAccountRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Account account = request.getAccount();
        String href = this.getAccounts().getHref();
        int querySeparator = 63;
        if (request.isRegistrationWorkflowOptionSpecified()) {
            href = href + (char)querySeparator + "registrationWorkflowEnabled=" + request.isRegistrationWorkflowEnabled();
            querySeparator = 38;
        }
        if (request.isPasswordFormatSpecified()) {
            href = href + (char)querySeparator + "passwordFormat=" + request.getPasswordFormat();
        }
        if (request.isAccountOptionsSpecified()) {
            return this.getDataStore().create(href, account, (Options)request.getAccountOptions());
        }
        return this.getDataStore().create(href, account);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public ApplicationAccountStoreMappingList getAccountStoreMappings() {
        return (ApplicationAccountStoreMappingList)this.getResourceProperty(ACCOUNT_STORE_MAPPINGS);
    }

    public ApplicationAccountStoreMappingList getAccountStoreMappings(Map<String, Object> queryParams) {
        ApplicationAccountStoreMappingList accountStoreMappings = this.getAccountStoreMappings();
        return this.getDataStore().getResource(accountStoreMappings.getHref(), ApplicationAccountStoreMappingList.class, queryParams);
    }

    public ApplicationAccountStoreMappingList getAccountStoreMappings(ApplicationAccountStoreMappingCriteria criteria) {
        ApplicationAccountStoreMappingList accountStoreMappings = this.getAccountStoreMappings();
        return this.getDataStore().getResource(accountStoreMappings.getHref(), ApplicationAccountStoreMappingList.class, (Criteria)criteria);
    }

    public AccountStore getDefaultAccountStore() {
        ApplicationAccountStoreMapping accountStoreMap = this.getResourceProperty(DEFAULT_ACCOUNT_STORE_MAPPING);
        return accountStoreMap == null ? null : accountStoreMap.getAccountStore();
    }

    public void setDefaultAccountStore(AccountStore accountStore) {
        ApplicationAccountStoreMappingList applicationAccountStoreMappingList = this.getAccountStoreMappings();
        boolean needToCreateNewStore = true;
        for (ApplicationAccountStoreMapping accountStoreMapping : applicationAccountStoreMappingList) {
            if (!accountStoreMapping.getAccountStore().getHref().equals(accountStore.getHref())) continue;
            needToCreateNewStore = false;
            accountStoreMapping.setDefaultAccountStore(true);
            accountStoreMapping.save();
            this.setProperty(DEFAULT_ACCOUNT_STORE_MAPPING, (Object)accountStoreMapping);
            break;
        }
        if (needToCreateNewStore) {
            ApplicationAccountStoreMapping mapping = this.addAccountStore(accountStore);
            mapping.setDefaultAccountStore(true);
            mapping.save();
            this.setProperty(DEFAULT_ACCOUNT_STORE_MAPPING, (Object)mapping);
        }
        this.save();
    }

    public AccountStore getDefaultGroupStore() {
        ApplicationAccountStoreMapping accountStoreMap = this.getResourceProperty(DEFAULT_GROUP_STORE_MAPPING);
        return accountStoreMap == null ? null : accountStoreMap.getAccountStore();
    }

    public void setDefaultGroupStore(AccountStore accountStore) {
        ApplicationAccountStoreMappingList applicationAccountStoreMappingList = this.getAccountStoreMappings();
        boolean needToCreateNewStore = true;
        for (ApplicationAccountStoreMapping accountStoreMapping : applicationAccountStoreMappingList) {
            if (!accountStoreMapping.getAccountStore().getHref().equals(accountStore.getHref())) continue;
            needToCreateNewStore = false;
            accountStoreMapping.setDefaultGroupStore(true);
            accountStoreMapping.save();
            this.setProperty(DEFAULT_GROUP_STORE_MAPPING, (Object)accountStoreMapping);
            break;
        }
        if (needToCreateNewStore) {
            ApplicationAccountStoreMapping mapping = this.addAccountStore(accountStore);
            mapping.setDefaultGroupStore(true);
            mapping.save();
            this.setProperty(DEFAULT_GROUP_STORE_MAPPING, (Object)mapping);
        }
        this.save();
    }

    public ApplicationAccountStoreMapping createAccountStoreMapping(ApplicationAccountStoreMapping mapping) throws ResourceException {
        String href = this.getAccountStoreMappingsHref();
        return this.getDataStore().create(href, mapping);
    }

    public ApplicationAccountStoreMapping addAccountStore(AccountStore accountStore) throws ResourceException {
        ApplicationAccountStoreMapping accountStoreMapping = (ApplicationAccountStoreMapping)this.getDataStore().instantiate(ApplicationAccountStoreMapping.class);
        accountStoreMapping.setAccountStore(accountStore);
        accountStoreMapping.setApplication((Application)this);
        accountStoreMapping.setListIndex(Integer.MAX_VALUE);
        return this.createAccountStoreMapping(accountStoreMapping);
    }

    public ApiKey getApiKey(String id) throws ResourceException, IllegalArgumentException {
        return this.getApiKey(id, new DefaultApiKeyOptions());
    }

    public ApiKey getApiKey(String id, ApiKeyOptions options) throws ResourceException, IllegalArgumentException {
        Assert.hasText((String)id, (String)"The 'id' argument cannot be null or empty to get an api key.");
        Assert.notNull((Object)options, (String)"options argument cannot be null.");
        Assert.hasText((String)this.getHref(), (String)"The application must have an href to get an api key.");
        DefaultApiKeyCriteria criteria = new DefaultApiKeyCriteria();
        criteria.add(new DefaultEqualsExpressionFactory(ApiKeyParameter.ID.getName()).eq(id));
        if (!options.isEmpty() && options instanceof Expandable) {
            Expandable expandable = (Expandable)options;
            for (Expansion exp : expandable.getExpansions()) {
                if ("tenant".equals(exp.getName())) {
                    criteria.withTenant();
                }
                if (!"account".equals(exp.getName())) continue;
                criteria.withAccount();
            }
        }
        String href = this.getHref() + "/apiKeys";
        ApiKeyList apiKeys = this.getDataStore().getResource(href, ApiKeyList.class, criteria);
        Iterator iterator = apiKeys.iterator();
        return iterator.hasNext() ? (ApiKey)iterator.next() : null;
    }

    private void validateUri(String uri) {
        try {
            URL uRL = new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(INVALID_URI_FORMAT_MSG);
        }
    }

    private String getAccountStoreMappingsHref() {
        String href = "/accountStoreMappings";
        return href;
    }

    public IdSiteUrlBuilder newIdSiteUrlBuilder() {
        return new DefaultIdSiteUrlBuilder(this.getDataStore(), this.getHref());
    }

    public SamlIdpUrlBuilder newSamlIdpUrlBuilder() {
        return new DefaultSamlIdpUrlBuilder(this.getDataStore(), this.getHref(), this.getSamlPolicy().getSamlServiceProvider().getSsoInitiationEndpoint().getHref());
    }

    public IdSiteCallbackHandler newIdSiteCallbackHandler(Object httpRequest) {
        this.validateHttpRequest(httpRequest);
        return new DefaultIdSiteCallbackHandler(this.getDataStore(), this, httpRequest);
    }

    public SamlCallbackHandler newSamlCallbackHandler(Object httpRequest) {
        this.validateHttpRequest(httpRequest);
        return new DefaultSamlCallbackHandler(this.getDataStore(), this, httpRequest);
    }

    public void sendVerificationEmail(VerificationEmailRequest verificationEmailRequest) {
        Assert.notNull((Object)verificationEmailRequest, (String)"verificationEmailRequest must not be null.");
        Assert.hasText((String)verificationEmailRequest.getLogin(), (String)"verificationEmailRequest's email property is required.");
        AccountStore accountStore = verificationEmailRequest.getAccountStore();
        if (accountStore != null && accountStore.getHref() == null) {
            throw new IllegalArgumentException("verificationEmailRequest's accountStore has been specified but its href is null.");
        }
        String href = this.getHref() + "/verificationEmails";
        this.getDataStore().create(href, (DefaultVerificationEmailRequest)verificationEmailRequest, DefaultVerificationEmailRequest.class);
    }

    private void validateHttpRequest(Object httpRequest) {
        Assert.notNull((Object)httpRequest);
        Class<?> httpRequestClass = httpRequest.getClass();
        for (Class supportedClass : HTTP_REQUEST_SUPPORTED_CLASSES) {
            if (!supportedClass.isAssignableFrom(httpRequestClass)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format(HTTP_REQUEST_NOT_SUPPORTED_MSG, httpRequestClass.getName(), HTTP_REQUEST_SUPPORTED_CLASSES.toString()));
    }

    public ApplicationAccountStoreMapping addAccountStore(String hrefOrName) {
        Assert.hasText((String)hrefOrName, (String)"hrefOrName cannot be null or empty.");
        AccountStore accountStore = null;
        String[] splitHrefOrName = hrefOrName.split("/");
        if (splitHrefOrName.length > 4) {
            Class<Directory> accountStoreType = null;
            String[] splitApplicationHref = this.getHref().split("/");
            if (splitHrefOrName.length == splitApplicationHref.length) {
                if (splitHrefOrName[4].equals("directories")) {
                    accountStoreType = Directory.class;
                } else if (splitHrefOrName[4].equals("groups")) {
                    accountStoreType = Group.class;
                } else if (splitHrefOrName[4].equals("organizations")) {
                    accountStoreType = Organization.class;
                }
            }
            if (accountStoreType != null) {
                try {
                    accountStore = (AccountStore)this.getDataStore().getResource(hrefOrName, accountStoreType);
                }
                catch (ResourceException resourceException) {
                    // empty catch block
                }
            }
        }
        if (accountStore == null) {
            Directory directory = this.getSingleTenantDirectory(Directories.where((Criterion)Directories.name().eqIgnoreCase(hrefOrName)));
            Group group = this.getSingleTenantGroup(Groups.where((Criterion)Groups.name().eqIgnoreCase(hrefOrName)));
            if (directory != null && group != null) {
                throw new IllegalArgumentException("There are both a Directory and a Group matching the provided name in the current tenant. Please provide the href of the intended Resource instead of its name in order to univocally identify it.");
            }
            Object object = accountStore = directory != null ? directory : group;
        }
        if (accountStore != null) {
            return this.addAccountStore(accountStore);
        }
        return null;
    }

    public ApplicationAccountStoreMapping addAccountStore(DirectoryCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria cannot be null.");
        Directory directory = this.getSingleTenantDirectory(criteria);
        if (directory != null) {
            return this.addAccountStore((AccountStore)directory);
        }
        return null;
    }

    public ApplicationAccountStoreMapping addAccountStore(OrganizationCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria cannot be null.");
        Organization organization = this.getSingleOrganization(criteria);
        if (organization != null) {
            return this.addAccountStore((AccountStore)organization);
        }
        return null;
    }

    public ApplicationAccountStoreMapping addAccountStore(GroupCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria cannot be null.");
        Group group = this.getSingleTenantGroup(criteria);
        if (group != null) {
            return this.addAccountStore((AccountStore)group);
        }
        return null;
    }

    private Directory getSingleTenantDirectory(DirectoryCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria cannot be null.");
        Tenant tenant = (Tenant)this.getDataStore().getResource("/tenants/current", Tenant.class);
        DirectoryList directories = tenant.getDirectories(criteria);
        Directory foundDirectory = null;
        for (Directory dir : directories) {
            if (foundDirectory != null) {
                throw new IllegalArgumentException("The provided criteria matched more than one Directory in the current Tenant.");
            }
            foundDirectory = dir;
        }
        return foundDirectory;
    }

    private Group getSingleTenantGroup(GroupCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria cannot be null.");
        Tenant tenant = (Tenant)this.getDataStore().getResource("/tenants/current", Tenant.class);
        DirectoryList directories = tenant.getDirectories();
        Group foundGroup = null;
        for (Directory directory : directories) {
            GroupList groups = directory.getGroups(criteria);
            for (Group grp : groups) {
                if (foundGroup != null) {
                    throw new IllegalArgumentException("The provided criteria matched more than one Group in the current Tenant.");
                }
                foundGroup = grp;
            }
        }
        return foundGroup;
    }

    private Organization getSingleOrganization(OrganizationCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria cannot be null.");
        Tenant tenant = (Tenant)this.getDataStore().getResource("/tenants/current", Tenant.class);
        OrganizationList organizations = tenant.getOrganizations(criteria);
        Organization found = null;
        int count = 0;
        for (Organization org : organizations) {
            ++count;
            found = org;
        }
        if (count > 1) {
            throw new IllegalArgumentException("The provided criteria matched more than one Organization in the current Tenant.");
        }
        return found;
    }

    public Application saveWithResponseOptions(ApplicationOptions responseOptions) {
        Assert.notNull((Object)responseOptions, (String)"responseOptions can't be null.");
        this.applyCustomDataUpdatesIfNecessary();
        this.getDataStore().save(this, (Options)responseOptions);
        return this;
    }

    public OAuthClientCredentialsGrantRequestAuthenticator createClientCredentialsGrantAuthenticator() {
        return new DefaultOAuthClientCredentialsGrantRequestAuthenticator(this, this.getDataStore());
    }

    public OAuthPasswordGrantRequestAuthenticator createPasswordGrantAuthenticator() {
        return new DefaultOAuthPasswordGrantRequestAuthenticator(this, this.getDataStore());
    }

    public OAuthRefreshTokenRequestAuthenticator createRefreshGrantAuthenticator() {
        return new DefaultOAuthRefreshTokenRequestAuthenticator(this, this.getDataStore());
    }

    public OAuthBearerRequestAuthenticator createJwtAuthenticator() {
        return new DefaultOAuthBearerRequestAuthenticator(this, this.getDataStore());
    }

    public IdSiteAuthenticator createIdSiteAuthenticator() {
        return new DefaultIdSiteAuthenticator(this, this.getDataStore());
    }

    static {
        OAUTH_AUTHENTICATION_REQUEST_BUILDER_CLASS = Classes.isAvailable((String)OAUTH_REQUEST_AUTHENTICATOR_FQCN) ? Classes.forName((String)OAUTH_REQUEST_AUTHENTICATOR_FQCN) : null;
        AUTHENTICATION_REQUEST_DISPATCHER_CLASS = Classes.isAvailable((String)OAUTH_AUTHENTICATION_REQUEST_DISPATCHER_FQCN) ? Classes.forName((String)OAUTH_AUTHENTICATION_REQUEST_DISPATCHER_FQCN) : AuthenticationRequestDispatcher.class;
        OAUTH_BUILDER_NOT_AVAILABLE_MSG = "Unable to find the 'com.stormpath.sdk.impl.oauth.authc.DefaultOAuthRequestAuthenticator' implementation on the classpath.  Please ensure you have added the stormpath-sdk-oauth-{version}.jar file to your runtime classpath.";
        HashSet<Class> supportedClasses = new HashSet<Class>();
        supportedClasses.add(HttpRequest.class);
        if (Classes.isAvailable((String)HTTP_SERVLET_REQUEST_FQCN)) {
            supportedClasses.add(Classes.forName((String)HTTP_SERVLET_REQUEST_FQCN));
        }
        HTTP_REQUEST_SUPPORTED_CLASSES = supportedClasses;
        log = LoggerFactory.getLogger(DefaultApplication.class);
        NAME = new StringProperty("name");
        DESCRIPTION = new StringProperty("description");
        STATUS = new StatusProperty<ApplicationStatus>(ApplicationStatus.class);
        TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
        DEFAULT_ACCOUNT_STORE_MAPPING = new ResourceReference<ApplicationAccountStoreMapping>("defaultAccountStoreMapping", ApplicationAccountStoreMapping.class);
        DEFAULT_GROUP_STORE_MAPPING = new ResourceReference<ApplicationAccountStoreMapping>("defaultGroupStoreMapping", ApplicationAccountStoreMapping.class);
        OAUTH_POLICY = new ResourceReference<OAuthPolicy>("oAuthPolicy", OAuthPolicy.class);
        SAML_POLICY = new ResourceReference<SamlPolicy>("samlPolicy", SamlPolicy.class);
        ACCOUNTS = new CollectionReference<AccountList, Account>("accounts", AccountList.class, Account.class);
        GROUPS = new CollectionReference<GroupList, Group>("groups", GroupList.class, Group.class);
        ACCOUNT_STORE_MAPPINGS = new CollectionReference<ApplicationAccountStoreMappingList, ApplicationAccountStoreMapping>("accountStoreMappings", ApplicationAccountStoreMappingList.class, ApplicationAccountStoreMapping.class);
        PASSWORD_RESET_TOKENS = new CollectionReference<PasswordResetTokenList, PasswordResetToken>("passwordResetTokens", PasswordResetTokenList.class, PasswordResetToken.class);
        AUTHORIZED_CALLBACK_URIS = new ListProperty(AUTHORIZED_CALLBACK_URIS_PROPERTY_NAME);
        PROPERTY_DESCRIPTORS = DefaultApplication.createPropertyDescriptorMap(NAME, DESCRIPTION, STATUS, TENANT, DEFAULT_ACCOUNT_STORE_MAPPING, DEFAULT_GROUP_STORE_MAPPING, ACCOUNTS, GROUPS, ACCOUNT_STORE_MAPPINGS, PASSWORD_RESET_TOKENS, CUSTOM_DATA, OAUTH_POLICY, AUTHORIZED_CALLBACK_URIS, SAML_POLICY);
    }
}

