/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc;

import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.error.authc.InvalidAuthenticationException;
import com.stormpath.sdk.error.authc.MissingApiKeyException;
import com.stormpath.sdk.error.authc.UnsupportedAuthenticationSchemeException;
import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.http.HttpRequest;
import com.stormpath.sdk.impl.authc.DefaultBasicApiAuthenticationRequest;
import com.stormpath.sdk.impl.authc.OAuthAuthenticationRequestFactory;
import com.stormpath.sdk.impl.error.ApiAuthenticationExceptionFactory;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.oauth.RequestLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ApiAuthenticationRequestFactory {
    private static final Set<String> SUPPORTED_AUTHENTICATION_SCHEMES;
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String BASIC_AUTHENTICATION_SCHEME = "Basic";
    public static final String BEARER_AUTHENTICATION_SCHEME = "Bearer";
    public static final String GRANT_TYPE_PARAMETER = "grant_type";

    public AuthenticationRequest createFrom(HttpRequest httpRequest) {
        String authzHeaderValue = httpRequest.getHeader(AUTHORIZATION_HEADER);
        String[] schemeAndValue = this.getSchemeAndValue(authzHeaderValue);
        if (schemeAndValue == null) {
            RequestLocation[] requestLocations = this.getRequestLocations(httpRequest, false);
            if (requestLocations.length > 0) {
                return OAuthAuthenticationRequestFactory.INSTANCE.createRequest(httpRequest, requestLocations);
            }
        } else {
            if (schemeAndValue[0].equalsIgnoreCase(BEARER_AUTHENTICATION_SCHEME)) {
                RequestLocation[] requestLocations = this.getRequestLocations(httpRequest, true);
                return OAuthAuthenticationRequestFactory.INSTANCE.createRequest(httpRequest, requestLocations);
            }
            if (schemeAndValue[0].equalsIgnoreCase(BASIC_AUTHENTICATION_SCHEME)) {
                Map parameterMap;
                if (this.hasContentType(httpRequest.getHeader(CONTENT_TYPE_HEADER), "application/x-www-form-urlencoded") && (parameterMap = httpRequest.getParameters()) != null && parameterMap.containsKey(GRANT_TYPE_PARAMETER)) {
                    return OAuthAuthenticationRequestFactory.INSTANCE.createTokenRequest(httpRequest);
                }
                return new DefaultBasicApiAuthenticationRequest(httpRequest);
            }
        }
        throw ApiAuthenticationExceptionFactory.newApiAuthenticationException(InvalidAuthenticationException.class);
    }

    protected String[] getSchemeAndValue(String authzHeaderValue) {
        if (authzHeaderValue == null) {
            return null;
        }
        String[] tokens = authzHeaderValue.split(" ", 2);
        if (tokens.length != 2) {
            throw ApiAuthenticationExceptionFactory.newApiAuthenticationException(MissingApiKeyException.class);
        }
        this.validateSupportedScheme(tokens[0]);
        return tokens;
    }

    private void validateSupportedScheme(String scheme) {
        for (String supportedScheme : SUPPORTED_AUTHENTICATION_SCHEMES) {
            if (!supportedScheme.equalsIgnoreCase(scheme)) continue;
            return;
        }
        throw ApiAuthenticationExceptionFactory.newApiAuthenticationException(UnsupportedAuthenticationSchemeException.class);
    }

    protected boolean hasContentType(String requestContentType, String requiredContentType) {
        if (!Strings.hasText((String)requiredContentType) || !Strings.hasText((String)requestContentType)) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(requestContentType, ";");
        while (tokenizer.hasMoreTokens()) {
            if (!requiredContentType.equalsIgnoreCase(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    protected RequestLocation[] getRequestLocations(HttpRequest request, boolean addHeaderLocation) {
        EnumSet<HttpMethod> bodyLocationMethods;
        HttpMethod method = request.getMethod();
        String contentType = request.getHeader(CONTENT_TYPE_HEADER);
        ArrayList<RequestLocation> requestLocationList = new ArrayList<RequestLocation>();
        if (addHeaderLocation) {
            requestLocationList.add(RequestLocation.HEADER);
        }
        if ((bodyLocationMethods = EnumSet.of(HttpMethod.POST, HttpMethod.DELETE, HttpMethod.PUT)).contains(method) && this.hasContentType(contentType, "application/x-www-form-urlencoded")) {
            requestLocationList.add(RequestLocation.BODY);
        }
        RequestLocation[] requestLocations = new RequestLocation[requestLocationList.size()];
        return requestLocationList.toArray(requestLocations);
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add(BASIC_AUTHENTICATION_SCHEME);
        tempSet.add(BEARER_AUTHENTICATION_SCHEME);
        SUPPORTED_AUTHENTICATION_SCHEMES = Collections.unmodifiableSet(tempSet);
    }
}

