/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc;

import com.stormpath.sdk.authc.AuthenticationOptions;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.error.authc.InvalidApiKeyException;
import com.stormpath.sdk.error.authc.MissingApiKeyException;
import com.stormpath.sdk.error.authc.UnsupportedAuthenticationSchemeException;
import com.stormpath.sdk.http.HttpRequest;
import com.stormpath.sdk.impl.authc.HttpServletRequestWrapper;
import com.stormpath.sdk.impl.error.ApiAuthenticationExceptionFactory;
import com.stormpath.sdk.impl.util.Base64;
import com.stormpath.sdk.lang.Assert;
import java.nio.charset.Charset;

public class DefaultBasicApiAuthenticationRequest
implements AuthenticationRequest<String, String> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final HttpRequest httpRequest;
    private final HttpServletRequestWrapper httpServletRequestWrapper;
    private final String id;
    private final String secret;

    public DefaultBasicApiAuthenticationRequest(HttpServletRequestWrapper httpServletRequestWrapper) {
        this(httpServletRequestWrapper, null);
    }

    public DefaultBasicApiAuthenticationRequest(HttpRequest httpRequest) {
        this(null, httpRequest);
    }

    private DefaultBasicApiAuthenticationRequest(HttpServletRequestWrapper httpServletRequestWrapper, HttpRequest httpRequest) {
        this.httpServletRequestWrapper = httpServletRequestWrapper;
        this.httpRequest = httpRequest;
        Assert.isTrue((this.hasHttpServletRequest() || this.hasHttpRequest() ? 1 : 0) != 0);
        String authzHeaderValue = this.hasHttpRequest() ? httpRequest.getHeader("Authorization") : httpServletRequestWrapper.getHeader("Authorization");
        String[] authTokens = this.getAuthenticationTokens(authzHeaderValue);
        this.id = authTokens[0];
        this.secret = authTokens[1];
    }

    private String[] getAuthenticationTokens(String authzHeaderValue) {
        String encodedAuthenticationTokens = this.getEncodedAuthenticationToken(authzHeaderValue);
        byte[] encodedBytes = encodedAuthenticationTokens.getBytes(UTF_8);
        if (!Base64.isBase64(encodedBytes)) {
            throw ApiAuthenticationExceptionFactory.newApiAuthenticationException(InvalidApiKeyException.class);
        }
        String decoded = new String(Base64.decodeBase64(encodedBytes), UTF_8);
        String[] tokens = decoded.split(":", 2);
        if (tokens.length != 2) {
            throw ApiAuthenticationExceptionFactory.newApiAuthenticationException(InvalidApiKeyException.class);
        }
        return tokens;
    }

    private String getEncodedAuthenticationToken(String authzHeaderValue) {
        if (authzHeaderValue == null) {
            throw ApiAuthenticationExceptionFactory.newApiAuthenticationException(MissingApiKeyException.class);
        }
        String[] schemeAndValue = authzHeaderValue.split(" ", 2);
        if (schemeAndValue.length != 2) {
            throw ApiAuthenticationExceptionFactory.newApiAuthenticationException(MissingApiKeyException.class);
        }
        if (!"Basic".equalsIgnoreCase(schemeAndValue[0])) {
            throw ApiAuthenticationExceptionFactory.newApiAuthenticationException(UnsupportedAuthenticationSchemeException.class);
        }
        return schemeAndValue[1];
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public boolean hasHttpRequest() {
        return this.httpRequest != null;
    }

    public boolean hasHttpServletRequest() {
        return this.httpServletRequestWrapper != null;
    }

    public String getPrincipals() {
        return this.id;
    }

    public String getCredentials() {
        return this.secret;
    }

    public String getHost() {
        throw new UnsupportedOperationException("getHost() this operation is not supported ApiAuthenticationRequest..");
    }

    public void clear() {
        throw new UnsupportedOperationException("clear() this operation is not supported ApiAuthenticationRequest..");
    }

    public AccountStore getAccountStore() {
        throw new UnsupportedOperationException("getAccountStore() this operation is not supported ApiAuthenticationRequest.");
    }

    public AuthenticationOptions getResponseOptions() {
        throw new UnsupportedOperationException("getResponseOptions() this operation is not supported in ApiAuthenticationRequest.");
    }
}

