/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc;

import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.BasicAuthenticationOptions;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.lang.Assert;

public class DefaultUsernamePasswordRequest
implements AuthenticationRequest<String, char[]> {
    private String username;
    private char[] password;
    private String host;
    private AccountStore accountStore;
    private BasicAuthenticationOptions authenticationOptions;

    public DefaultUsernamePasswordRequest(String usernameOrEmail, char[] password) {
        Assert.hasText((String)usernameOrEmail, (String)"usernameOrEmail cannot be null or empty.");
        this.username = usernameOrEmail;
        this.password = password;
    }

    public String getPrincipals() {
        return this.username;
    }

    public char[] getCredentials() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public DefaultUsernamePasswordRequest setHost(String host) {
        Assert.hasText((String)host, (String)"host cannot be null or empty.");
        this.host = host;
        return this;
    }

    public AccountStore getAccountStore() {
        return this.accountStore;
    }

    public DefaultUsernamePasswordRequest setAccountStore(AccountStore accountStore) {
        Assert.notNull((Object)accountStore, (String)"accountStore cannot be null.");
        this.accountStore = accountStore;
        return this;
    }

    public BasicAuthenticationOptions getResponseOptions() {
        return this.authenticationOptions;
    }

    public DefaultUsernamePasswordRequest setResponseOptions(BasicAuthenticationOptions options) {
        Assert.notNull((Object)options, (String)"options cannot be null.");
        this.authenticationOptions = options;
        return this;
    }

    public void clear() {
        this.username = null;
        this.host = null;
        this.accountStore = null;
        this.authenticationOptions = null;
        char[] password = this.password;
        this.password = null;
        if (password != null) {
            for (int i = 0; i < password.length; ++i) {
                password[i] = '\u0000';
            }
        }
    }
}

