/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.client;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.cache.CacheConfigurationBuilder;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.cache.CacheManagerBuilder;
import com.stormpath.sdk.cache.Caches;
import com.stormpath.sdk.client.AuthenticationScheme;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.client.ClientBuilder;
import com.stormpath.sdk.client.Proxy;
import com.stormpath.sdk.impl.authc.credentials.ApiKeyCredentials;
import com.stormpath.sdk.impl.authc.credentials.ClientCredentials;
import com.stormpath.sdk.impl.authc.credentials.DefaultClientCredentialsProviderChain;
import com.stormpath.sdk.impl.client.DefaultClient;
import com.stormpath.sdk.impl.config.ClientConfiguration;
import com.stormpath.sdk.impl.config.JSONPropertiesSource;
import com.stormpath.sdk.impl.config.OptionalPropertiesSource;
import com.stormpath.sdk.impl.config.PropertiesSource;
import com.stormpath.sdk.impl.config.ResourcePropertiesSource;
import com.stormpath.sdk.impl.config.YAMLPropertiesSource;
import com.stormpath.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.stormpath.sdk.impl.io.DefaultResourceFactory;
import com.stormpath.sdk.impl.io.Resource;
import com.stormpath.sdk.lang.Assert;
import io.jsonwebtoken.lang.Classes;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientBuilder
implements ClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultClientBuilder.class);
    private ApiKey apiKey;
    private Proxy proxy;
    private CacheManager cacheManager;
    private ClientCredentials clientCredentials;
    private static final String USER_HOME = System.getProperty("user.home") + File.separatorChar;
    private static final String STORMPATH_PROPERTIES = "stormpath.properties";
    private static final String[] DEFAULT_STORMPATH_PROPERTIES_FILE_LOCATIONS = new String[]{"classpath:com/stormpath/sdk/config/stormpath.properties", "classpath:stormpath.properties", USER_HOME + ".stormpath" + File.separatorChar + "stormpath.properties", USER_HOME + "stormpath.properties"};
    private ClientConfiguration clientConfig = new ClientConfiguration();

    /*
     * WARNING - void declaration
     */
    public DefaultClientBuilder() {
        void var5_7;
        ArrayList<OptionalPropertiesSource> sources = new ArrayList<OptionalPropertiesSource>();
        DefaultResourceFactory resourceFactory = new DefaultResourceFactory();
        String[] stringArray = DEFAULT_STORMPATH_PROPERTIES_FILE_LOCATIONS;
        int n = stringArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            String location = stringArray[var5_7];
            Resource resource = resourceFactory.createResource(location);
            OptionalPropertiesSource propertiesSource = new OptionalPropertiesSource(new ResourcePropertiesSource(resource));
            sources.add(propertiesSource);
            if (!location.equals(DEFAULT_STORMPATH_PROPERTIES_FILE_LOCATIONS[0]) && location.endsWith(".properties")) {
                String jsonFile = location.replace(".properties", ".json");
                resource = resourceFactory.createResource(jsonFile);
                OptionalPropertiesSource jsonSource = new OptionalPropertiesSource(new JSONPropertiesSource(resource));
                sources.add(jsonSource);
                String yamlFile = location.replace(".properties", ".yaml");
                resource = resourceFactory.createResource(yamlFile);
                OptionalPropertiesSource yamlSource = new OptionalPropertiesSource(new YAMLPropertiesSource(resource));
                sources.add(yamlSource);
            }
            ++var5_7;
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (PropertiesSource propertiesSource : sources) {
            Map<String, String> srcProps = propertiesSource.getProperties();
            props.putAll(srcProps);
        }
        if (props.get("stormpath.client.apiKey.file") != null) {
            Object apiKeyFile = (String)props.get("stormpath.client.apiKey.file");
            apiKeyFile = ((String)apiKeyFile).replace("\\:", ":");
            this.clientConfig.setApiKeyFile((String)apiKeyFile);
        }
        if (props.get("stormpath.client.apiKey.id") != null) {
            this.clientConfig.setApiKeyId((String)props.get("stormpath.client.apiKey.id"));
        }
        if (props.get("stormpath.client.apiKey.secret") != null) {
            this.clientConfig.setApiKeySecret((String)props.get("stormpath.client.apiKey.secret"));
        }
        if (props.get("stormpath.client.cacheManager.enabled") != null) {
            this.clientConfig.setCacheManagerEnabled(Boolean.valueOf((String)props.get("stormpath.client.cacheManager.enabled")));
        }
        if (props.get("stormpath.client.cacheManager.defaultTtl") != null) {
            this.clientConfig.setCacheManagerTtl(Long.valueOf((String)props.get("stormpath.client.cacheManager.defaultTtl")));
        }
        if (props.get("stormpath.client.cacheManager.defaultTti") != null) {
            this.clientConfig.setCacheManagerTti(Long.valueOf((String)props.get("stormpath.client.cacheManager.defaultTti")));
        }
        for (String string : props.keySet()) {
            boolean isPrefix = string.length() == "stormpath.client.cacheManager.caches".length();
            if (isPrefix || !string.startsWith("stormpath.client.cacheManager.caches")) continue;
            String cacheClass = string.substring("stormpath.client.cacheManager.caches".length() + 1, string.length() - 4);
            String cacheTti = (String)props.get("stormpath.client.cacheManager.caches." + cacheClass + ".tti");
            String cacheTtl = (String)props.get("stormpath.client.cacheManager.caches." + cacheClass + ".ttl");
            CacheConfigurationBuilder cacheBuilder = Caches.forResource((Class)Classes.forName((String)cacheClass));
            if (cacheTti != null) {
                cacheBuilder.withTimeToIdle(Long.valueOf(cacheTti).longValue(), TimeUnit.SECONDS);
            }
            if (cacheTtl != null) {
                cacheBuilder.withTimeToLive(Long.valueOf(cacheTtl).longValue(), TimeUnit.SECONDS);
            }
            if (this.clientConfig.getCacheManagerCaches().containsKey(cacheClass)) continue;
            this.clientConfig.getCacheManagerCaches().put(cacheClass, cacheBuilder);
        }
        if (props.get("stormpath.client.baseUrl") != null) {
            String baseUrl = (String)props.get("stormpath.client.baseUrl");
            baseUrl = baseUrl.replace("\\:", ":");
            this.clientConfig.setBaseUrl(baseUrl);
        }
        if (props.get("stormpath.client.connectionTimeout") != null) {
            this.clientConfig.setConnectionTimeout(Integer.valueOf((String)props.get("stormpath.client.connectionTimeout")));
        }
        if (props.get("stormpath.client.authenticationScheme") != null) {
            this.clientConfig.setAuthenticationScheme(Enum.valueOf(AuthenticationScheme.class, (String)props.get("stormpath.client.authenticationScheme")));
        }
        if (props.get("stormpath.client.proxy.port") != null) {
            this.clientConfig.setProxyPort(Integer.valueOf((String)props.get("stormpath.client.proxy.port")));
        }
        if (props.get("stormpath.client.proxy.host") != null) {
            this.clientConfig.setProxyHost((String)props.get("stormpath.client.proxy.host"));
        }
        if (props.get("stormpath.client.proxy.username") != null) {
            this.clientConfig.setProxyUsername((String)props.get("stormpath.client.proxy.username"));
        }
        if (props.get("stormpath.client.proxy.password") != null) {
            this.clientConfig.setProxyPassword((String)props.get("stormpath.client.proxy.password"));
        }
    }

    public ClientBuilder setApiKey(ApiKey apiKey) {
        Assert.notNull((Object)apiKey, (String)"apiKey cannot be null.");
        this.apiKey = apiKey;
        return this;
    }

    public ClientBuilder setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy argument cannot be null.");
        }
        this.proxy = proxy;
        return this;
    }

    public ClientBuilder setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        return this;
    }

    public ClientBuilder setAuthenticationScheme(AuthenticationScheme authenticationScheme) {
        this.clientConfig.setAuthenticationScheme(authenticationScheme);
        return this;
    }

    public ClientBuilder setConnectionTimeout(int timeout) {
        Assert.isTrue((timeout >= 0 ? 1 : 0) != 0, (String)"Timeout cannot be a negative number.");
        this.clientConfig.setConnectionTimeout(timeout);
        return this;
    }

    public ClientBuilder setRequestAuthenticatorFactory(RequestAuthenticatorFactory factory) {
        Assert.notNull((Object)factory, (String)"factory argument cannot be null");
        this.clientConfig.setRequestAuthenticatorFactory(factory);
        return this;
    }

    public ClientBuilder setClientCredentials(ClientCredentials clientCredentials) {
        Assert.isInstanceOf(ClientCredentials.class, (Object)clientCredentials);
        this.clientCredentials = clientCredentials;
        return this;
    }

    public Client build() {
        ClientCredentials clientCredentials;
        if (!this.clientConfig.isCacheManagerEnabled()) {
            log.debug("CacheManager disabled. Defaulting to DisabledCacheManager");
            this.cacheManager = Caches.newDisabledCacheManager();
        } else if (this.cacheManager == null) {
            log.debug("No CacheManager configured. Defaulting to in-memory CacheManager with default TTL and TTI of five minutes.");
            CacheManagerBuilder cacheManagerBuilder = Caches.newCacheManager().withDefaultTimeToIdle(this.clientConfig.getCacheManagerTti(), TimeUnit.SECONDS).withDefaultTimeToLive(this.clientConfig.getCacheManagerTtl(), TimeUnit.SECONDS);
            if (this.clientConfig.getCacheManagerCaches().size() > 0) {
                for (CacheConfigurationBuilder builder : this.clientConfig.getCacheManagerCaches().values()) {
                    cacheManagerBuilder.withCache(builder);
                }
            }
            this.cacheManager = cacheManagerBuilder.build();
        }
        if (this.clientConfig.getProxyPort() > 0 || this.clientConfig.getProxyHost() != null && (this.clientConfig.getProxyUsername() == null || this.clientConfig.getProxyPassword() == null)) {
            this.proxy = new Proxy(this.clientConfig.getProxyHost(), this.clientConfig.getProxyPort());
        } else if (this.clientConfig.getProxyUsername() != null && this.clientConfig.getProxyPassword() != null) {
            this.proxy = new Proxy(this.clientConfig.getProxyHost(), this.clientConfig.getProxyPort(), this.clientConfig.getProxyUsername(), this.clientConfig.getProxyPassword());
        }
        if (this.clientCredentials != null) {
            clientCredentials = this.clientCredentials;
        } else if (this.apiKey != null) {
            clientCredentials = new ApiKeyCredentials(this.apiKey);
        } else {
            DefaultClientCredentialsProviderChain clientCredentialsProvider = new DefaultClientCredentialsProviderChain(this.clientConfig);
            clientCredentials = clientCredentialsProvider.getClientCredentials();
        }
        return new DefaultClient(clientCredentials, this.clientConfig.getBaseUrl(), this.proxy, this.cacheManager, this.clientConfig.getAuthenticationScheme(), this.clientConfig.getRequestAuthenticatorFactory(), this.clientConfig.getConnectionTimeout());
    }

    public ClientBuilder setBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl argument cannot be null.");
        }
        this.clientConfig.setBaseUrl(baseUrl);
        return this;
    }

    ClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }
}

