/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.directory;

import com.stormpath.sdk.directory.AccountCreationPolicy;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.mail.EmailStatus;
import com.stormpath.sdk.mail.ModeledEmailTemplate;
import com.stormpath.sdk.mail.ModeledEmailTemplateList;
import com.stormpath.sdk.mail.UnmodeledEmailTemplate;
import com.stormpath.sdk.mail.UnmodeledEmailTemplateList;
import java.util.Map;

public class DefaultAccountCreationPolicy
extends AbstractInstanceResource
implements AccountCreationPolicy {
    static final StatusProperty<EmailStatus> ACCOUNT_VERIFICATION_EMAIL_STATUS = new StatusProperty<EmailStatus>("verificationEmailStatus", EmailStatus.class);
    static final StatusProperty<EmailStatus> ACCOUNT_VERIFICATION_SUCCESS_EMAIL_STATUS = new StatusProperty<EmailStatus>("verificationSuccessEmailStatus", EmailStatus.class);
    static final StatusProperty<EmailStatus> WELCOME_EMAIL_STATUS = new StatusProperty<EmailStatus>("welcomeEmailStatus", EmailStatus.class);
    static final CollectionReference<ModeledEmailTemplateList, ModeledEmailTemplate> ACCOUNT_VERIFICATION_EMAIL_TEMPLATES = new CollectionReference<ModeledEmailTemplateList, ModeledEmailTemplate>("verificationEmailTemplates", ModeledEmailTemplateList.class, ModeledEmailTemplate.class);
    static final CollectionReference<UnmodeledEmailTemplateList, UnmodeledEmailTemplate> ACCOUNT_VERIFICATION_SUCCESS_EMAIL_TEMPLATES = new CollectionReference<UnmodeledEmailTemplateList, UnmodeledEmailTemplate>("verificationSuccessEmailTemplates", UnmodeledEmailTemplateList.class, UnmodeledEmailTemplate.class);
    static final CollectionReference<UnmodeledEmailTemplateList, UnmodeledEmailTemplate> WELCOME_EMAIL_TEMPLATES = new CollectionReference<UnmodeledEmailTemplateList, UnmodeledEmailTemplate>("welcomeEmailTemplates", UnmodeledEmailTemplateList.class, UnmodeledEmailTemplate.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultAccountCreationPolicy.createPropertyDescriptorMap(ACCOUNT_VERIFICATION_EMAIL_STATUS, ACCOUNT_VERIFICATION_SUCCESS_EMAIL_STATUS, WELCOME_EMAIL_STATUS, ACCOUNT_VERIFICATION_EMAIL_TEMPLATES, ACCOUNT_VERIFICATION_SUCCESS_EMAIL_TEMPLATES, WELCOME_EMAIL_TEMPLATES);

    public DefaultAccountCreationPolicy(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAccountCreationPolicy(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public ModeledEmailTemplateList getAccountVerificationEmailTemplates() {
        return (ModeledEmailTemplateList)this.getResourceProperty(ACCOUNT_VERIFICATION_EMAIL_TEMPLATES);
    }

    public UnmodeledEmailTemplateList getAccountVerificationSuccessEmailTemplates() {
        return (UnmodeledEmailTemplateList)this.getResourceProperty(ACCOUNT_VERIFICATION_SUCCESS_EMAIL_TEMPLATES);
    }

    public UnmodeledEmailTemplateList getWelcomeEmailTemplates() {
        return (UnmodeledEmailTemplateList)this.getResourceProperty(WELCOME_EMAIL_TEMPLATES);
    }

    public EmailStatus getVerificationEmailStatus() {
        String value = this.getStringProperty(ACCOUNT_VERIFICATION_EMAIL_STATUS.getName());
        if (value == null) {
            return null;
        }
        return EmailStatus.valueOf((String)value.toUpperCase());
    }

    public AccountCreationPolicy setVerificationEmailStatus(EmailStatus accountVerificationEmailStatus) {
        Assert.notNull((Object)accountVerificationEmailStatus, (String)"accountVerificationEmailStatus cannot be null.");
        this.setProperty(ACCOUNT_VERIFICATION_EMAIL_STATUS, (Object)accountVerificationEmailStatus.name());
        return this;
    }

    public EmailStatus getVerificationSuccessEmailStatus() {
        String value = this.getStringProperty(ACCOUNT_VERIFICATION_SUCCESS_EMAIL_STATUS.getName());
        if (value == null) {
            return null;
        }
        return EmailStatus.valueOf((String)value.toUpperCase());
    }

    public AccountCreationPolicy setVerificationSuccessEmailStatus(EmailStatus accountVerificationSuccessEmailStatus) {
        Assert.notNull((Object)accountVerificationSuccessEmailStatus, (String)"accountVerificationSuccessEmailStatus cannot be null.");
        this.setProperty(ACCOUNT_VERIFICATION_SUCCESS_EMAIL_STATUS, (Object)accountVerificationSuccessEmailStatus.name());
        return this;
    }

    public EmailStatus getWelcomeEmailStatus() {
        String value = this.getStringProperty(WELCOME_EMAIL_STATUS.getName());
        if (value == null) {
            return null;
        }
        return EmailStatus.valueOf((String)value.toUpperCase());
    }

    public AccountCreationPolicy setWelcomeEmailStatus(EmailStatus welcomeEmailStatus) {
        Assert.notNull((Object)welcomeEmailStatus, (String)"welcomeEmailStatus cannot be null.");
        this.setProperty(WELCOME_EMAIL_STATUS, (Object)welcomeEmailStatus.name());
        return this;
    }
}

