/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.directory;

import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.DateProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefaultCustomData
extends AbstractInstanceResource
implements CustomData {
    static final DateProperty CREATED_AT = new DateProperty("createdAt");
    static final DateProperty MODIFIED_AT = new DateProperty("modifiedAt");
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultCustomData.createPropertyDescriptorMap(CREATED_AT, MODIFIED_AT);

    public DefaultCustomData(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultCustomData(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Date getCreatedAt() {
        return this.getDateProperty(CREATED_AT);
    }

    public Date getModifiedAt() {
        return this.getDateProperty(MODIFIED_AT);
    }

    public void delete() {
        this.writeLock.lock();
        try {
            this.getDataStore().delete(this);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int size() {
        this.readLock.lock();
        try {
            LinkedHashSet keySet = new LinkedHashSet();
            keySet.addAll(this.properties.keySet());
            keySet.addAll(this.dirtyProperties.keySet());
            keySet.removeAll(this.deletedPropertyNames);
            int n = keySet.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    public boolean containsValue(Object value) {
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        return super.getProperty(key.toString());
    }

    public Object put(String key, Object value) {
        return super.setProperty(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        this.writeLock.lock();
        try {
            Object object = this.dirtyProperties.remove(key);
            this.deletedPropertyNames.add(key.toString());
            this.dirty = true;
            Object v = object;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends String, ?> m) {
        if (Collections.isEmpty(m)) {
            return;
        }
        Set<Map.Entry<String, ?>> entrySet = m.entrySet();
        this.writeLock.lock();
        try {
            for (Map.Entry<String, ?> entry : entrySet) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            HashSet<String> propertiesToFilter = new HashSet<String>();
            propertiesToFilter.add("href");
            propertiesToFilter.addAll(this.getPropertyDescriptors().keySet());
            for (String propertyName : this.keySet()) {
                if (propertiesToFilter.contains(propertyName)) continue;
                this.dirtyProperties.remove(propertyName);
                this.deletedPropertyNames.add(propertyName);
                this.dirty = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> keySet() {
        if (!this.isMaterialized()) {
            this.writeLock.lock();
            try {
                this.materialize();
            }
            finally {
                this.writeLock.unlock();
            }
        }
        this.readLock.lock();
        try {
            LinkedHashSet keySet = new LinkedHashSet();
            keySet.addAll(this.properties.keySet());
            keySet.addAll(this.dirtyProperties.keySet());
            keySet.removeAll(this.deletedPropertyNames);
            Set<String> set = java.util.Collections.unmodifiableSet(keySet);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<Object> values() {
        Set<String> keySet = this.keySet();
        ArrayList<Object> values = new ArrayList<Object>(keySet.size());
        for (String key : keySet) {
            values.add(this.get(key));
        }
        return java.util.Collections.unmodifiableCollection(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<String> keySet = this.keySet();
        this.readLock.lock();
        try {
            LinkedHashSet<AbstractMap.SimpleEntry<String, Object>> entrySet = new LinkedHashSet<AbstractMap.SimpleEntry<String, Object>>(keySet.size());
            for (String key : keySet) {
                entrySet.add(new AbstractMap.SimpleEntry<String, Object>(key, this.get(key)));
            }
            Set set = java.util.Collections.unmodifiableSet(entrySet);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void save() {
        if (this.isDirty()) {
            this.writeLock.lock();
            try {
                if (this.hasRemovedProperties()) {
                    this.deleteRemovedProperties();
                }
                if (this.hasNewProperties()) {
                    super.save();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRemovedProperties() {
        this.writeLock.lock();
        try {
            Set<String> deletedPropertyNames = this.getDeletedPropertyNames();
            for (String deletedPropertyName : deletedPropertyNames) {
                this.getDataStore().deleteResourceProperty(this, deletedPropertyName);
                this.properties.remove(deletedPropertyName);
            }
            this.deletedPropertyNames.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasRemovedProperties() {
        this.readLock.lock();
        try {
            boolean bl = !this.deletedPropertyNames.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasNewProperties() {
        this.readLock.lock();
        try {
            boolean bl = !this.dirtyProperties.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.keySet();
    }
}

