/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.directory;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.account.Accounts;
import com.stormpath.sdk.account.CreateAccountRequest;
import com.stormpath.sdk.directory.AccountCreationPolicy;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.directory.DirectoryOptions;
import com.stormpath.sdk.directory.DirectoryStatus;
import com.stormpath.sdk.directory.PasswordPolicy;
import com.stormpath.sdk.group.CreateGroupRequest;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.group.Groups;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.provider.IdentityProviderType;
import com.stormpath.sdk.impl.resource.AbstractExtendableInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.organization.Organization;
import com.stormpath.sdk.organization.OrganizationAccountStoreMapping;
import com.stormpath.sdk.organization.OrganizationAccountStoreMappingCriteria;
import com.stormpath.sdk.organization.OrganizationAccountStoreMappingList;
import com.stormpath.sdk.organization.OrganizationCriteria;
import com.stormpath.sdk.organization.OrganizationList;
import com.stormpath.sdk.provider.Provider;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Map;

public class DefaultDirectory
extends AbstractExtendableInstanceResource
implements Directory {
    static final StringProperty NAME = new StringProperty("name");
    static final StringProperty DESCRIPTION = new StringProperty("description");
    static final StatusProperty<DirectoryStatus> STATUS = new StatusProperty<DirectoryStatus>(DirectoryStatus.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final ResourceReference<Provider> PROVIDER = new ResourceReference<Provider>("provider", Provider.class);
    static final ResourceReference<PasswordPolicy> PASSWORD_POLICY = new ResourceReference<PasswordPolicy>("passwordPolicy", PasswordPolicy.class);
    static final ResourceReference<AccountCreationPolicy> ACCOUNT_CREATION_POLICY = new ResourceReference<AccountCreationPolicy>("accountCreationPolicy", AccountCreationPolicy.class);
    static final CollectionReference<AccountList, Account> ACCOUNTS = new CollectionReference<AccountList, Account>("accounts", AccountList.class, Account.class);
    static final CollectionReference<GroupList, Group> GROUPS = new CollectionReference<GroupList, Group>("groups", GroupList.class, Group.class);
    static final CollectionReference<OrganizationList, Organization> ORGANIZATIONS = new CollectionReference<OrganizationList, Organization>("organizations", OrganizationList.class, Organization.class);
    static final CollectionReference<OrganizationAccountStoreMappingList, OrganizationAccountStoreMapping> ORGANIZATION_MAPPINGS = new CollectionReference<OrganizationAccountStoreMappingList, OrganizationAccountStoreMapping>("organizationMappings", OrganizationAccountStoreMappingList.class, OrganizationAccountStoreMapping.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultDirectory.createPropertyDescriptorMap(NAME, DESCRIPTION, STATUS, TENANT, PROVIDER, ACCOUNTS, GROUPS, CUSTOM_DATA, PASSWORD_POLICY, ACCOUNT_CREATION_POLICY, ORGANIZATION_MAPPINGS, ORGANIZATIONS);

    public DefaultDirectory(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultDirectory(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public Directory setName(String name) {
        this.setProperty(NAME, (Object)name);
        return this;
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public Directory setDescription(String description) {
        this.setProperty(DESCRIPTION, (Object)description);
        return this;
    }

    public DirectoryStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return DirectoryStatus.valueOf((String)value.toUpperCase());
    }

    public Directory setStatus(DirectoryStatus status) {
        this.setProperty(STATUS, (Object)status.name());
        return this;
    }

    public Account createAccount(Account account) {
        Assert.notNull((Object)account, (String)"account cannot be null.");
        return this.createAccount(Accounts.newCreateRequestFor((Account)account).build());
    }

    public Account createAccount(Account account, boolean registrationWorkflowEnabled) {
        Assert.notNull((Object)account, (String)"account cannot be null.");
        return this.createAccount(Accounts.newCreateRequestFor((Account)account).setRegistrationWorkflowEnabled(registrationWorkflowEnabled).build());
    }

    public Account createAccount(CreateAccountRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Account account = request.getAccount();
        String href = this.getAccounts().getHref();
        if (request.isRegistrationWorkflowOptionSpecified()) {
            href = href + "?registrationWorkflowEnabled=" + request.isRegistrationWorkflowEnabled();
        }
        if (request.isAccountOptionsSpecified()) {
            return this.getDataStore().create(href, account, (Options)request.getAccountOptions());
        }
        return this.getDataStore().create(href, account);
    }

    public AccountList getAccounts() {
        return (AccountList)this.getResourceProperty(ACCOUNTS);
    }

    public AccountList getAccounts(Map<String, Object> queryParams) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, queryParams);
    }

    public AccountList getAccounts(AccountCriteria criteria) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, (Criteria)criteria);
    }

    public GroupList getGroups() {
        return (GroupList)this.getResourceProperty(GROUPS);
    }

    public GroupList getGroups(Map<String, Object> queryParams) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, queryParams);
    }

    public GroupList getGroups(GroupCriteria criteria) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, (Criteria)criteria);
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public Group createGroup(Group group) {
        Assert.notNull((Object)group, (String)"Group cannot be null.");
        return this.createGroup(Groups.newCreateRequestFor((Group)group).build());
    }

    public Group createGroup(CreateGroupRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Group group = request.getGroup();
        String href = this.getGroups().getHref();
        if (request.isGroupOptionsSpecified()) {
            return this.getDataStore().create(href, group, (Options)request.getGroupOptions());
        }
        return this.getDataStore().create(href, group);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public void accept(AccountStoreVisitor visitor) {
        visitor.visit((Directory)this);
    }

    public Provider getProvider() {
        Object value = this.getProperty(PROVIDER.getName());
        if (Provider.class.isInstance(value) || value == null) {
            return (Provider)value;
        }
        if (value instanceof Map && !((Map)value).isEmpty()) {
            String href = (String)((Map)value).get("href");
            if (href == null) {
                throw new IllegalStateException("provider resource does not contain its required href property.");
            }
            Provider provider = (Provider)this.getDataStore().getResource(href, Provider.class, "providerId", IdentityProviderType.IDENTITY_PROVIDER_CLASS_MAP);
            this.setProperty(PROVIDER, (Object)provider);
            return provider;
        }
        String msg = "'" + PROVIDER.getName() + "' property value type does not match the specified type. Specified type: " + PROVIDER.getType() + ".  Existing type: " + value.getClass().getName() + ".  Value: " + value;
        throw new IllegalStateException(msg);
    }

    public Directory setProvider(Provider provider) {
        Assert.state((this.getHref() == null ? 1 : 0) != 0, (String)"cannot change the provider of an existing Directory.");
        this.setProperty(PROVIDER, (Object)provider);
        return this;
    }

    public PasswordPolicy getPasswordPolicy() {
        return this.getResourceProperty(PASSWORD_POLICY);
    }

    public AccountCreationPolicy getAccountCreationPolicy() {
        return this.getResourceProperty(ACCOUNT_CREATION_POLICY);
    }

    public Directory saveWithResponseOptions(DirectoryOptions responseOptions) {
        Assert.notNull((Object)responseOptions, (String)"responseOptions can't be null.");
        this.applyCustomDataUpdatesIfNecessary();
        this.getDataStore().save(this, (Options)responseOptions);
        return this;
    }

    public OrganizationList getOrganizations() {
        return (OrganizationList)this.getResourceProperty(ORGANIZATIONS);
    }

    public OrganizationList getOrganizations(Map<String, Object> queryParams) {
        OrganizationList list = this.getOrganizations();
        return this.getDataStore().getResource(list.getHref(), OrganizationList.class, queryParams);
    }

    public OrganizationList getOrganizations(OrganizationCriteria criteria) {
        OrganizationList list = this.getOrganizations();
        return this.getDataStore().getResource(list.getHref(), OrganizationList.class, (Criteria)criteria);
    }

    public OrganizationAccountStoreMappingList getOrganizationAccountStoreMappings() {
        return (OrganizationAccountStoreMappingList)this.getResourceProperty(ORGANIZATION_MAPPINGS);
    }

    public OrganizationAccountStoreMappingList getOrganizationAccountStoreMappings(Map<String, Object> queryParams) {
        OrganizationAccountStoreMappingList list = this.getOrganizationAccountStoreMappings();
        return this.getDataStore().getResource(list.getHref(), OrganizationAccountStoreMappingList.class, queryParams);
    }

    public OrganizationAccountStoreMappingList getOrganizationAccountStoreMappings(OrganizationAccountStoreMappingCriteria criteria) {
        OrganizationList list = this.getOrganizations();
        return this.getDataStore().getResource(list.getHref(), OrganizationAccountStoreMappingList.class, (Criteria)criteria);
    }
}

