/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.directory;

import com.stormpath.sdk.directory.PasswordPolicy;
import com.stormpath.sdk.directory.PasswordStrength;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.IntegerProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.mail.EmailStatus;
import com.stormpath.sdk.mail.ModeledEmailTemplate;
import com.stormpath.sdk.mail.ModeledEmailTemplateList;
import com.stormpath.sdk.mail.UnmodeledEmailTemplate;
import com.stormpath.sdk.mail.UnmodeledEmailTemplateList;
import java.util.Map;

public class DefaultPasswordPolicy
extends AbstractInstanceResource
implements PasswordPolicy {
    static final IntegerProperty RESET_TOKEN_TTL = new IntegerProperty("resetTokenTtl");
    static final StatusProperty<EmailStatus> RESET_EMAIL_STATUS = new StatusProperty<EmailStatus>("resetEmailStatus", EmailStatus.class);
    static final StatusProperty<EmailStatus> RESET_SUCCESS_EMAIL_STATUS = new StatusProperty<EmailStatus>("resetSuccessEmailStatus", EmailStatus.class);
    static final ResourceReference<PasswordStrength> STRENGTH = new ResourceReference<PasswordStrength>("strength", PasswordStrength.class);
    static final CollectionReference<ModeledEmailTemplateList, ModeledEmailTemplate> RESET_EMAIL_TEMPLATES = new CollectionReference<ModeledEmailTemplateList, ModeledEmailTemplate>("resetEmailTemplates", ModeledEmailTemplateList.class, ModeledEmailTemplate.class);
    static final CollectionReference<UnmodeledEmailTemplateList, UnmodeledEmailTemplate> RESET_SUCCESS_EMAIL_TEMPLATES = new CollectionReference<UnmodeledEmailTemplateList, UnmodeledEmailTemplate>("resetSuccessEmailTemplates", UnmodeledEmailTemplateList.class, UnmodeledEmailTemplate.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultPasswordPolicy.createPropertyDescriptorMap(RESET_TOKEN_TTL, RESET_EMAIL_STATUS, RESET_SUCCESS_EMAIL_STATUS, STRENGTH, RESET_EMAIL_TEMPLATES, RESET_SUCCESS_EMAIL_TEMPLATES);

    public DefaultPasswordPolicy(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultPasswordPolicy(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public int getResetTokenTtlHours() {
        return this.getInt(RESET_TOKEN_TTL);
    }

    public PasswordPolicy setResetTokenTtlHours(int resetTokenTtl) {
        Assert.isTrue((resetTokenTtl > 0 && resetTokenTtl < 169 ? 1 : 0) != 0, (String)"resetTokenTtl must be a positive integer, less than 169.");
        this.setProperty(RESET_TOKEN_TTL, (Object)resetTokenTtl);
        return this;
    }

    public EmailStatus getResetEmailStatus() {
        String value = this.getStringProperty(RESET_EMAIL_STATUS.getName());
        if (value == null) {
            return null;
        }
        return EmailStatus.valueOf((String)value.toUpperCase());
    }

    public PasswordPolicy setResetEmailStatus(EmailStatus status) {
        Assert.notNull((Object)status, (String)"status cannot be null.");
        this.setProperty(RESET_EMAIL_STATUS, (Object)status.name());
        return this;
    }

    public EmailStatus getResetSuccessEmailStatus() {
        String value = this.getStringProperty(RESET_SUCCESS_EMAIL_STATUS.getName());
        if (value == null) {
            return null;
        }
        return EmailStatus.valueOf((String)value.toUpperCase());
    }

    public PasswordPolicy setResetSuccessEmailStatus(EmailStatus status) {
        Assert.notNull((Object)status, (String)"status cannot be null.");
        this.setProperty(RESET_SUCCESS_EMAIL_STATUS, (Object)status.name());
        return this;
    }

    public PasswordStrength getStrength() {
        return this.getResourceProperty(STRENGTH);
    }

    public ModeledEmailTemplateList getResetEmailTemplates() {
        return (ModeledEmailTemplateList)this.getResourceProperty(RESET_EMAIL_TEMPLATES);
    }

    public UnmodeledEmailTemplateList getResetSuccessEmailTemplates() {
        return (UnmodeledEmailTemplateList)this.getResourceProperty(RESET_SUCCESS_EMAIL_TEMPLATES);
    }
}

