/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds;

import com.stormpath.sdk.impl.ds.Filter;
import com.stormpath.sdk.impl.ds.FilterChain;
import com.stormpath.sdk.impl.ds.ResourceDataRequest;
import com.stormpath.sdk.impl.ds.ResourceDataResult;
import com.stormpath.sdk.lang.Assert;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilterChain
implements FilterChain {
    private static final Logger log = LoggerFactory.getLogger(DefaultFilterChain.class);
    private List<Filter> filters;
    private int index = 0;
    private final FilterChain COMPLETION_HANDLER;

    public DefaultFilterChain(List<Filter> filters, FilterChain completionHandler) {
        this.filters = filters;
        this.index = 0;
        Assert.notNull((Object)completionHandler, (String)"completionHandler cannot be null.");
        this.COMPLETION_HANDLER = completionHandler;
    }

    @Override
    public ResourceDataResult filter(ResourceDataRequest request) {
        if (this.filters == null || this.filters.size() == this.index) {
            if (log.isTraceEnabled()) {
                log.trace("Invoking completion handler.");
            }
            return this.COMPLETION_HANDLER.filter(request);
        }
        if (log.isTraceEnabled()) {
            log.trace("Invoking wrapped filter at index [" + this.index + "]");
        }
        return this.filters.get(this.index++).filter(request, this);
    }
}

