/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds;

import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.impl.ds.ResourceConverter;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.impl.resource.ReferenceFactory;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.mail.ModeledEmailTemplate;
import com.stormpath.sdk.provider.Provider;
import com.stormpath.sdk.provider.ProviderData;
import com.stormpath.sdk.resource.Resource;
import com.stormpath.sdk.saml.AttributeStatementMappingRules;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultResourceConverter
implements ResourceConverter {
    private final ReferenceFactory referenceFactory;

    public DefaultResourceConverter(ReferenceFactory referenceFactory) {
        Assert.notNull((Object)referenceFactory, (String)"referenceFactory cannot be null.");
        this.referenceFactory = referenceFactory;
    }

    @Override
    public Map<String, Object> convert(AbstractResource resource) {
        Assert.notNull((Object)resource, (String)"resource cannot be null.");
        return this.toMap(resource, true);
    }

    private LinkedHashMap<String, Object> toMap(AbstractResource resource, boolean partialUpdate) {
        Set<String> propNames = partialUpdate ? resource.getUpdatedPropertyNames() : resource.getPropertyNames();
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(propNames.size());
        for (String propName : propNames) {
            Object value = resource.getProperty(propName);
            value = this.toMapValue(resource, propName, value, partialUpdate);
            props.put(propName, value);
        }
        return props;
    }

    private Object toMapValue(AbstractResource resource, String propName, Object value, boolean partialUpdate) {
        if (resource instanceof CustomData) {
            return value;
        }
        if (value instanceof CustomData || value instanceof ProviderData || value instanceof Provider) {
            if (partialUpdate) {
                Assert.isInstanceOf(AbstractResource.class, (Object)value);
                AbstractResource abstractResource = (AbstractResource)((Object)value);
                Set<String> updatedPropertyNames = abstractResource.getUpdatedPropertyNames();
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(Collections.size(updatedPropertyNames));
                for (String updatedCustomPropertyName : updatedPropertyNames) {
                    Object object = abstractResource.getProperty(updatedCustomPropertyName);
                    if (object instanceof AttributeStatementMappingRules) {
                        object = this.convertAttributeStatementMappingRulesToMap(object);
                    }
                    properties.put(updatedCustomPropertyName, object);
                }
                value = properties;
            }
            return value;
        }
        if (value instanceof Map) {
            if (resource instanceof ModeledEmailTemplate && propName.equals("defaultModel")) {
                return value;
            }
            return this.referenceFactory.createReference(propName, value);
        }
        if (value instanceof Resource) {
            return this.referenceFactory.createReference(propName, (Resource)value);
        }
        return value;
    }

    private Object convertAttributeStatementMappingRulesToMap(Object object) {
        Set elementsSet = (Set)object;
        HashMap<String, List> map = new HashMap<String, List>();
        List list = Collections.toList((Object[])elementsSet.toArray());
        map.put("items", list);
        return map;
    }
}

