/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds.api;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyList;
import com.stormpath.sdk.impl.api.ApiKeyParameter;
import com.stormpath.sdk.impl.api.DefaultApiKeyCriteria;
import com.stormpath.sdk.impl.api.DefaultApiKeyList;
import com.stormpath.sdk.impl.ds.DefaultResourceDataRequest;
import com.stormpath.sdk.impl.ds.Filter;
import com.stormpath.sdk.impl.ds.FilterChain;
import com.stormpath.sdk.impl.ds.ResourceAction;
import com.stormpath.sdk.impl.ds.ResourceDataRequest;
import com.stormpath.sdk.impl.ds.ResourceDataResult;
import com.stormpath.sdk.impl.http.QueryString;
import com.stormpath.sdk.impl.http.QueryStringFactory;
import com.stormpath.sdk.impl.http.support.DefaultCanonicalUri;
import com.stormpath.sdk.impl.query.DefaultEqualsExpressionFactory;
import com.stormpath.sdk.impl.security.DefaultSaltGenerator;
import com.stormpath.sdk.impl.security.SaltGenerator;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.resource.Resource;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ApiKeyQueryFilter
implements Filter {
    private static String ENCRYPT_SECRET = ApiKeyParameter.ENCRYPT_SECRET.getName();
    private static String ENCRYPTION_KEY_SALT = ApiKeyParameter.ENCRYPTION_KEY_SALT.getName();
    private static String ENCRYPTION_KEY_SIZE = ApiKeyParameter.ENCRYPTION_KEY_SIZE.getName();
    private static String ENCRYPTION_KEY_ITERATIONS = ApiKeyParameter.ENCRYPTION_KEY_ITERATIONS.getName();
    private static String ENCRYPTION_METADATA = ApiKeyParameter.ENCRYPTION_METADATA.getName();
    private final SaltGenerator saltGenerator = new DefaultSaltGenerator();
    private final QueryStringFactory queryStringFactory;

    public ApiKeyQueryFilter(QueryStringFactory queryStringFactory) {
        this.queryStringFactory = queryStringFactory;
    }

    @Override
    public ResourceDataResult filter(ResourceDataRequest request, FilterChain chain) {
        boolean addEncryptionMetadata;
        if (request.getAction() == ResourceAction.DELETE) {
            return chain.filter(request);
        }
        Class<? extends Resource> clazz = request.getResourceClass();
        if (!ApiKey.class.isAssignableFrom(clazz) && !ApiKeyList.class.isAssignableFrom(clazz)) {
            return chain.filter(request);
        }
        QueryString query = request.getUri().getQuery();
        boolean isQueryEmpty = Collections.isEmpty((Map)query);
        boolean addEncryptionCriteria = isQueryEmpty || !query.containsKey(ENCRYPT_SECRET);
        boolean bl = addEncryptionMetadata = addEncryptionCriteria || Boolean.parseBoolean((String)query.get(ENCRYPT_SECRET));
        if (addEncryptionCriteria) {
            DefaultApiKeyCriteria criteria = new DefaultApiKeyCriteria();
            criteria.add(new DefaultEqualsExpressionFactory(ENCRYPT_SECRET).eq(Boolean.TRUE));
            criteria.add(new DefaultEqualsExpressionFactory(ENCRYPTION_KEY_SIZE).eq(128));
            criteria.add(new DefaultEqualsExpressionFactory(ENCRYPTION_KEY_ITERATIONS).eq(1024));
            criteria.add(new DefaultEqualsExpressionFactory(ENCRYPTION_KEY_SALT).eq(this.saltGenerator.generate()));
            QueryString encryptionQueryParams = this.queryStringFactory.createQueryString(criteria);
            if (query == null) {
                DefaultCanonicalUri uri = new DefaultCanonicalUri(request.getUri().getAbsolutePath(), encryptionQueryParams);
                request = new DefaultResourceDataRequest(request.getAction(), uri, request.getResourceClass(), request.getData());
            } else {
                query.putAll(encryptionQueryParams);
            }
        }
        ResourceDataResult result = chain.filter(request);
        if (addEncryptionMetadata) {
            query = request.getUri().getQuery();
            LinkedHashMap<String, Object> encryptionMetadata = new LinkedHashMap<String, Object>();
            String salt = (String)query.get(ENCRYPTION_KEY_SALT);
            Integer size = query.containsKey(ENCRYPTION_KEY_SIZE) ? Integer.valueOf((String)query.get(ENCRYPTION_KEY_SIZE)) : 128;
            Integer iterations = query.containsKey(ENCRYPTION_KEY_ITERATIONS) ? Integer.valueOf((String)query.get(ENCRYPTION_KEY_ITERATIONS)) : 1024;
            encryptionMetadata.put(ENCRYPTION_KEY_SALT, salt);
            encryptionMetadata.put(ENCRYPTION_KEY_SIZE, size);
            encryptionMetadata.put(ENCRYPTION_KEY_ITERATIONS, iterations);
            Map<String, Object> data = result.getData();
            if (DefaultApiKeyList.isCollectionResource(data)) {
                Collection items = (Collection)data.get("items");
                for (Map item : items) {
                    item.put(ENCRYPTION_METADATA, encryptionMetadata);
                }
            } else {
                data.put(ENCRYPTION_METADATA, encryptionMetadata);
            }
        }
        return result;
    }
}

