/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds.cache;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyList;
import com.stormpath.sdk.impl.api.ApiKeyParameter;
import com.stormpath.sdk.impl.authc.LoginAttempt;
import com.stormpath.sdk.impl.ds.DefaultResourceDataResult;
import com.stormpath.sdk.impl.ds.FilterChain;
import com.stormpath.sdk.impl.ds.ResourceAction;
import com.stormpath.sdk.impl.ds.ResourceDataRequest;
import com.stormpath.sdk.impl.ds.ResourceDataResult;
import com.stormpath.sdk.impl.ds.cache.AbstractCacheFilter;
import com.stormpath.sdk.impl.ds.cache.CacheResolver;
import com.stormpath.sdk.impl.http.CanonicalUri;
import com.stormpath.sdk.impl.http.QueryString;
import com.stormpath.sdk.impl.provider.ProviderAccountAccess;
import com.stormpath.sdk.impl.resource.AbstractCollectionResource;
import com.stormpath.sdk.impl.resource.CollectionProperties;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.resource.CollectionResource;
import com.stormpath.sdk.resource.Resource;
import java.util.Map;

public class ReadCacheFilter
extends AbstractCacheFilter {
    private final String baseUrl;

    public ReadCacheFilter(String baseUrl, CacheResolver cacheResolver, boolean collectionCachingEnabled) {
        super(cacheResolver, collectionCachingEnabled);
        Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty.");
        this.baseUrl = baseUrl;
    }

    @Override
    public ResourceDataResult filter(ResourceDataRequest request, FilterChain chain) {
        ResourceDataResult result;
        if (this.isCacheRetrievalEnabled(request) && (result = this.getCachedResourceData(request)) != null) {
            return result;
        }
        return chain.filter(request);
    }

    private ResourceDataResult getCachedResourceData(ResourceDataRequest request) {
        CanonicalUri uri = request.getUri();
        String href = uri.getAbsolutePath();
        QueryString query = uri.getQuery();
        Class<? extends Resource> clazz = request.getResourceClass();
        CollectionProperties data = null;
        if (this.isApiKeyCollectionQuery(request)) {
            Class<ApiKey> cacheClass;
            String cacheHref = this.baseUrl + "/apiKeys/" + (String)query.get(ApiKeyParameter.ID.getName());
            Map<String, ?> apiKeyData = this.getCachedValue(cacheHref, cacheClass = ApiKey.class);
            if (!Collections.isEmpty(apiKeyData)) {
                int offset = this.getValue(query, AbstractCollectionResource.OFFSET.getName(), 0);
                int limit = this.getValue(query, AbstractCollectionResource.LIMIT.getName(), 25);
                data = new CollectionProperties.Builder().setHref(href).setOffset(offset).setLimit(limit).setItemsMap(apiKeyData).build();
            }
        } else {
            String cacheKey = this.getCacheKey(request);
            if (!request.getUri().hasQuery() || !(request.getUri().getQuery().containsKey("expand") ^ (cacheKey != null && cacheKey.contains("expand=")))) {
                data = this.getCachedValue(cacheKey, clazz);
            }
        }
        if (Collections.isEmpty(data)) {
            return null;
        }
        return new DefaultResourceDataResult(request.getAction(), uri, clazz, ReadCacheFilter.coerce(data));
    }

    private int getValue(QueryString query, String propName, int defaultValue) {
        return query.containsKey(propName) ? Integer.valueOf((String)query.get(propName)) : defaultValue;
    }

    private static Map<String, Object> coerce(Map<String, ?> data) {
        return data;
    }

    private boolean isApiKeyCollectionQuery(ResourceDataRequest request) {
        return ApiKeyList.class.isAssignableFrom(request.getResourceClass()) && request.getUri().hasQuery() && request.getUri().getQuery().containsKey(ApiKeyParameter.ID.getName());
    }

    private boolean isCacheRetrievalEnabled(ResourceDataRequest request) {
        Class<? extends Resource> clazz = request.getResourceClass();
        return request.getAction() == ResourceAction.READ && !LoginAttempt.class.isAssignableFrom(clazz) && !ProviderAccountAccess.class.isAssignableFrom(clazz) && (!CollectionResource.class.isAssignableFrom(clazz) || ApiKeyList.class.isAssignableFrom(clazz) || CollectionResource.class.isAssignableFrom(clazz) && this.isCollectionCachingEnabled());
    }
}

