/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.error;

import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.error.authc.DisabledAccountException;
import com.stormpath.sdk.error.authc.OAuthAuthenticationException;
import com.stormpath.sdk.impl.error.DefaultErrorBuilder;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.resource.ResourceException;
import java.lang.reflect.Constructor;

public class ApiAuthenticationExceptionFactory {
    public static final int AUTH_EXCEPTION_STATUS = 401;
    public static final int AUTH_EXCEPTION_CODE = 401;
    public static final String MORE_INFO = "http://docs.stormpath.com/java/quickstart";
    private static final String DEFAULT_DEVELOPER_MESSAGE = "Authentication with a valid API Key is required.";
    private static final String DEFAULT_CLIENT_MESSAGE = "Authentication Required";

    public static ResourceException newApiAuthenticationException(Class<? extends ResourceException> clazz) {
        Error error = DefaultErrorBuilder.status(401).code(401).moreInfo(MORE_INFO).developerMessage(DEFAULT_DEVELOPER_MESSAGE).message(DEFAULT_CLIENT_MESSAGE).build();
        Constructor constructor = Classes.getConstructor(clazz, (Class[])new Class[]{Error.class});
        return (ResourceException)((Object)Classes.instantiate((Constructor)constructor, (Object[])new Object[]{error}));
    }

    public static DisabledAccountException newDisabledAccountException(AccountStatus accountStatus) {
        Error error = DefaultErrorBuilder.status(401).code(401).moreInfo(MORE_INFO).developerMessage(DEFAULT_DEVELOPER_MESSAGE).message(DEFAULT_CLIENT_MESSAGE).build();
        return new DisabledAccountException(error, accountStatus);
    }

    public static ResourceException newApiAuthenticationException(Class<? extends ResourceException> clazz, String message) {
        Error error = DefaultErrorBuilder.status(401).code(401).moreInfo(MORE_INFO).developerMessage(message).message(DEFAULT_CLIENT_MESSAGE).build();
        Constructor<? extends ResourceException> constructor = ApiAuthenticationExceptionFactory.getConstructorFromClass(clazz);
        return (ResourceException)((Object)Classes.instantiate(constructor, (Object[])new Object[]{error}));
    }

    public static ResourceException newOAuthException(Class<? extends OAuthAuthenticationException> clazz, String oauthError) {
        Error error = DefaultErrorBuilder.status(401).code(401).moreInfo(MORE_INFO).developerMessage(oauthError).message(DEFAULT_CLIENT_MESSAGE).build();
        Constructor<? extends ResourceException> constructor = ApiAuthenticationExceptionFactory.getConstructorFromClass(clazz);
        return (ResourceException)((Object)Classes.instantiate(constructor, (Object[])new Object[]{error, oauthError}));
    }

    private static Constructor<? extends ResourceException> getConstructorFromClass(Class<? extends ResourceException> clazz) {
        if (OAuthAuthenticationException.class.isAssignableFrom(clazz)) {
            return Classes.getConstructor(clazz, (Class[])new Class[]{Error.class, String.class});
        }
        return Classes.getConstructor(clazz, (Class[])new Class[]{Error.class});
    }
}

