/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.idsite;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.idsite.IdSiteUrlBuilder;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.http.QueryString;
import com.stormpath.sdk.impl.idsite.IdSiteClaims;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.UUID;

public class DefaultIdSiteUrlBuilder
implements IdSiteUrlBuilder {
    public static String SSO_LOGOUT_SUFFIX = "/logout";
    public final String ssoEndpoint;
    private final InternalDataStore internalDataStore;
    private final String applicationHref;
    private final IdSiteClaims claims;
    private boolean logout = false;

    public DefaultIdSiteUrlBuilder(InternalDataStore internalDataStore, String applicationHref) {
        Assert.notNull((Object)internalDataStore, (String)"internalDataStore cannot be null.");
        Assert.hasText((String)applicationHref, (String)"applicationHref cannot be null or empty");
        this.ssoEndpoint = this.getBaseUrl(applicationHref) + "/sso";
        this.internalDataStore = internalDataStore;
        this.applicationHref = applicationHref;
        this.claims = new IdSiteClaims();
    }

    public IdSiteUrlBuilder setCallbackUri(String callbackUri) {
        this.claims.setCallbackUri(callbackUri);
        return this;
    }

    public IdSiteUrlBuilder setState(String state) {
        this.claims.setState(state);
        return this;
    }

    public IdSiteUrlBuilder setPath(String path) {
        this.claims.setPath(path);
        return this;
    }

    public IdSiteUrlBuilder setOrganizationNameKey(String organizationNameKey) {
        this.claims.setOrganizationNameKey(organizationNameKey);
        return this;
    }

    public IdSiteUrlBuilder setUseSubdomain(boolean useSubdomain) {
        this.claims.setUseSubdomain(useSubdomain);
        return this;
    }

    public IdSiteUrlBuilder setShowOrganizationField(boolean showOrganizationField) {
        this.claims.setShowOrganizationField(showOrganizationField);
        return this;
    }

    public IdSiteUrlBuilder setSpToken(String spToken) {
        this.claims.setSpToken(spToken);
        return this;
    }

    public IdSiteUrlBuilder addProperty(String name, Object value) {
        this.claims.put(name, value);
        return this;
    }

    public IdSiteUrlBuilder forLogout() {
        this.logout = true;
        return this;
    }

    public String build() {
        Assert.state((boolean)Strings.hasText((String)this.claims.getCallbackUri()), (String)"callbackUri cannot be null or empty.");
        String jti = UUID.randomUUID().toString();
        Date now = new Date();
        ApiKey apiKey = this.internalDataStore.getApiKey();
        JwtBuilder jwtBuilder = Jwts.builder().setClaims((Claims)this.claims).setId(jti).setIssuedAt(now).setIssuer(apiKey.getId()).setSubject(this.applicationHref);
        byte[] secret = apiKey.getSecret().getBytes(Strings.UTF_8);
        String jwt = jwtBuilder.setHeaderParam("typ", (Object)"JWT").signWith(SignatureAlgorithm.HS256, secret).compact();
        QueryString queryString = new QueryString();
        queryString.put("jwtRequest", jwt);
        StringBuilder urlBuilder = new StringBuilder(this.ssoEndpoint);
        if (this.logout) {
            urlBuilder.append(SSO_LOGOUT_SUFFIX);
        }
        return urlBuilder.append('?').append(queryString.toString()).toString();
    }

    protected String getBaseUrl(String href) {
        String baseUrl;
        try {
            String DOUBLE_SLASH = "//";
            int doubleSlashIndex = href.indexOf("//");
            int singleSlashIndex = href.indexOf("/", doubleSlashIndex + "//".length());
            singleSlashIndex = singleSlashIndex != -1 ? singleSlashIndex : href.length();
            baseUrl = href.substring(0, singleSlashIndex);
        }
        catch (Exception e) {
            throw new IllegalStateException("IDSite base URL could not be constructed.");
        }
        if (!Strings.hasText((String)baseUrl)) {
            throw new IllegalStateException("IDSite base URL could not be constructed.");
        }
        return baseUrl;
    }
}

