/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.idsite;

import com.stormpath.sdk.cache.Cache;
import com.stormpath.sdk.idsite.Nonce;
import com.stormpath.sdk.idsite.NonceStore;
import com.stormpath.sdk.impl.ds.cache.CacheResolver;
import com.stormpath.sdk.impl.idsite.DefaultNonce;
import com.stormpath.sdk.lang.Assert;
import java.util.Map;

public class DefaultNonceStore
implements NonceStore {
    private final CacheResolver cacheResolver;

    public DefaultNonceStore(CacheResolver cacheResolver) {
        Assert.notNull((Object)cacheResolver, (String)"cacheResolver cannot be null.");
        this.cacheResolver = cacheResolver;
    }

    public boolean hasNonce(String nonce) {
        Assert.hasText((String)nonce);
        Cache<String, Map<String, ?>> cache = this.cacheResolver.getCache(Nonce.class);
        Map values = (Map)cache.get((Object)nonce);
        return values != null;
    }

    public void putNonce(String nonce) {
        Assert.hasText((String)nonce);
        Cache<String, Map<String, ?>> cache = this.cacheResolver.getCache(Nonce.class);
        DefaultNonce defaultNonce = new DefaultNonce(nonce);
        cache.put((Object)defaultNonce.getValue(), defaultNonce.getProperties());
    }
}

