/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.oauth.AbstractBaseOAuthToken;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.AccessToken;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.util.Map;

public class DefaultAccessToken
extends AbstractBaseOAuthToken
implements AccessToken {
    public DefaultAccessToken(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
        this.ensureAccessToken();
    }

    private void ensureAccessToken() {
        if (this.isMaterialized()) {
            try {
                JwsHeader header = (JwsHeader)Jwts.parser().setSigningKey(this.getDataStore().getApiKey().getSecret().getBytes("UTF-8")).parseClaimsJws(this.getString(JWT)).getHeader();
                String tokenType = (String)header.get((Object)"stt");
                Assert.isTrue((boolean)tokenType.equals("access"));
            }
            catch (Exception e) {
                throw new JwtException("JWT failed validation; it cannot be trusted.");
            }
        } else {
            String href = this.getStringProperty("href");
            if (href != null) {
                Assert.isTrue((boolean)href.contains("/accessTokens/"), (String)"href does not belong to an access token.");
            }
        }
    }
}

