/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.oauth.AccessToken;
import com.stormpath.sdk.oauth.GrantAuthenticationToken;
import com.stormpath.sdk.oauth.RefreshToken;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultGrantAuthenticationToken
extends AbstractInstanceResource
implements GrantAuthenticationToken {
    static final StringProperty ACCESS_TOKEN = new StringProperty("access_token");
    static final StringProperty REFRESH_TOKEN = new StringProperty("refresh_token");
    static final StringProperty TOKEN_TYPE = new StringProperty("token_type");
    static final StringProperty EXPIRES_IN = new StringProperty("expires_in");
    static final StringProperty ACCESS_TOKEN_HREF = new StringProperty("stormpath_access_token_href");
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultGrantAuthenticationToken.createPropertyDescriptorMap(ACCESS_TOKEN, REFRESH_TOKEN, EXPIRES_IN, TOKEN_TYPE, ACCESS_TOKEN_HREF);

    public DefaultGrantAuthenticationToken(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGrantAuthenticationToken(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getAccessToken() {
        return this.getString(ACCESS_TOKEN);
    }

    public String getRefreshToken() {
        return this.getString(REFRESH_TOKEN);
    }

    public String getTokenType() {
        return this.getString(TOKEN_TYPE);
    }

    public String getExpiresIn() {
        return this.getString(EXPIRES_IN);
    }

    public String getAccessTokenHref() {
        return this.getString(ACCESS_TOKEN_HREF);
    }

    public AccessToken getAsAccessToken() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(1);
        props.put("href", this.getAccessTokenHref());
        return this.getDataStore().instantiate(AccessToken.class, props);
    }

    public RefreshToken getAsRefreshToken() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(1);
        String refreshTokenID = (String)((Map)this.getAsAccessToken().getExpandedJwt().get("claims")).get("rti");
        props.put("href", "/refreshTokens/" + refreshTokenID);
        return this.getDataStore().instantiate(RefreshToken.class, props);
    }
}

