/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.ds.DataStore;
import com.stormpath.sdk.impl.http.HttpHeaders;
import com.stormpath.sdk.impl.http.MediaType;
import com.stormpath.sdk.impl.oauth.AbstractOAuthRequestAuthenticator;
import com.stormpath.sdk.impl.oauth.DefaultIdSiteAuthenticationAttempt;
import com.stormpath.sdk.impl.oauth.DefaultOAuthGrantRequestAuthenticationResultBuilder;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.GrantAuthenticationToken;
import com.stormpath.sdk.oauth.IdSiteAuthenticationRequest;
import com.stormpath.sdk.oauth.IdSiteAuthenticator;
import com.stormpath.sdk.oauth.OAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthRequestAuthentication;

public class DefaultIdSiteAuthenticator
extends AbstractOAuthRequestAuthenticator
implements IdSiteAuthenticator {
    static final String OAUTH_TOKEN_PATH = "/oauth/token";

    public DefaultIdSiteAuthenticator(Application application, DataStore dataStore) {
        super(application, dataStore);
    }

    public OAuthGrantRequestAuthenticationResult authenticate(OAuthRequestAuthentication authenticationRequest) {
        Assert.notNull((Object)this.application, (String)"application cannot be null or empty");
        Assert.isInstanceOf(IdSiteAuthenticationRequest.class, (Object)authenticationRequest, (String)"authenticationRequest must be an instance of IdSiteAuthenticationRequest.");
        IdSiteAuthenticationRequest request = (IdSiteAuthenticationRequest)authenticationRequest;
        DefaultIdSiteAuthenticationAttempt attempt = new DefaultIdSiteAuthenticationAttempt(this.dataStore);
        attempt.setGrantType(request.getGrantType());
        attempt.setToken(request.getToken());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        GrantAuthenticationToken grantResult = this.dataStore.create(this.application.getHref() + OAUTH_TOKEN_PATH, attempt, GrantAuthenticationToken.class, httpHeaders);
        DefaultOAuthGrantRequestAuthenticationResultBuilder builder = new DefaultOAuthGrantRequestAuthenticationResultBuilder(grantResult);
        return builder.build();
    }
}

