/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.impl.oauth.DefaultOAuthBearerRequestAuthenticationResult;
import com.stormpath.sdk.impl.oauth.OAuthBearerRequestAuthenticationResultBuilder;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.AccessToken;
import com.stormpath.sdk.oauth.OAuthBearerRequestAuthenticationResult;

public class DefaultOAuthBearerRequestAuthenticationResultBuilder
implements OAuthBearerRequestAuthenticationResultBuilder {
    private final AccessToken accessToken;

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public DefaultOAuthBearerRequestAuthenticationResultBuilder(AccessToken accessToken) {
        Assert.notNull((Object)accessToken, (String)"accessToken cannot be null.");
        Assert.hasText((String)accessToken.getHref(), (String)"accessToken's href cannot be null or empty.");
        Assert.notNull((Object)accessToken.getApplication(), (String)"accessToken's application cannot be null.");
        Assert.notNull((Object)accessToken.getAccount(), (String)"accessToken's account cannot be null.");
        Assert.notNull((Object)accessToken.getTenant(), (String)"accessToken's tenant cannot be null.");
        Assert.hasText((String)accessToken.getJwt(), (String)"accessToken's JWT cannot be null or empty.");
        this.accessToken = accessToken;
    }

    @Override
    public OAuthBearerRequestAuthenticationResult build() {
        Assert.notNull((Object)this.accessToken, (String)"accessToken has not been set. It is a required attribute.");
        return new DefaultOAuthBearerRequestAuthenticationResult(this.accessToken);
    }
}

