/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.ds.DataStore;
import com.stormpath.sdk.impl.oauth.AbstractOAuthRequestAuthenticator;
import com.stormpath.sdk.impl.oauth.DefaultAccessToken;
import com.stormpath.sdk.impl.oauth.DefaultOAuthBearerRequestAuthenticationResultBuilder;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.AccessToken;
import com.stormpath.sdk.oauth.OAuthBearerRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthBearerRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthBearerRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthRequestAuthentication;
import com.stormpath.sdk.resource.ResourceException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.util.HashMap;

public class DefaultOAuthBearerRequestAuthenticator
extends AbstractOAuthRequestAuthenticator
implements OAuthBearerRequestAuthenticator {
    protected static final String APPLICATION_PATH = "/applications/";
    protected static final String OAUTH_TOKEN_PATH = "/authTokens/";
    protected static final String ACCESS_TOKEN_PATH = "/accessTokens/";
    protected Boolean isLocalValidation = false;

    public DefaultOAuthBearerRequestAuthenticator(Application application, DataStore dataStore) {
        super(application, dataStore);
    }

    public OAuthBearerRequestAuthenticator withLocalValidation() {
        this.isLocalValidation = Boolean.TRUE;
        return this;
    }

    public OAuthBearerRequestAuthenticationResult authenticate(OAuthRequestAuthentication authenticationRequest) {
        Assert.notNull((Object)this.application, (String)"application cannot be null or empty");
        Assert.isInstanceOf(OAuthBearerRequestAuthentication.class, (Object)authenticationRequest, (String)"authenticationRequest must be an instance of JwtAuthenticationRequest.");
        OAuthBearerRequestAuthentication bearerRequest = (OAuthBearerRequestAuthentication)authenticationRequest;
        if (this.isLocalValidation.booleanValue()) {
            String apiKeySecret = this.dataStore.getApiKey().getSecret();
            try {
                Claims claims = (Claims)Jwts.parser().setSigningKey(apiKeySecret.getBytes("UTF-8")).parseClaimsJws(bearerRequest.getJwt()).getBody();
                Assert.isTrue((boolean)claims.getIssuer().equals(this.application.getHref()));
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Account account = (Account)this.dataStore.getResource(claims.getSubject(), Account.class);
                String accessTokenHref = this.application.getHref().replace(APPLICATION_PATH, ACCESS_TOKEN_PATH);
                int accessTokenIdStartingPoint = accessTokenHref.lastIndexOf("/") + 1;
                accessTokenHref = accessTokenHref.substring(0, accessTokenIdStartingPoint);
                accessTokenHref = accessTokenHref + claims.getId();
                properties.put("href", accessTokenHref);
                properties.put("account", account);
                properties.put("application", this.application);
                properties.put("jwt", bearerRequest.getJwt());
                properties.put("tenant", this.application.getTenant());
                DefaultAccessToken accessToken = new DefaultAccessToken(this.dataStore, properties);
                DefaultOAuthBearerRequestAuthenticationResultBuilder builder = new DefaultOAuthBearerRequestAuthenticationResultBuilder(accessToken);
                return builder.build();
            }
            catch (Exception e) {
                throw new JwtException("JWT failed validation; it cannot be trusted.");
            }
        }
        StringBuilder stringBuilder = new StringBuilder(this.application.getHref());
        stringBuilder.append(OAUTH_TOKEN_PATH);
        stringBuilder.append(bearerRequest.getJwt());
        AccessToken accessToken = null;
        try {
            accessToken = (AccessToken)this.dataStore.getResource(stringBuilder.toString(), AccessToken.class);
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JwtException("JWT failed validation; it cannot be trusted.");
        }
        DefaultOAuthBearerRequestAuthenticationResultBuilder builder = new DefaultOAuthBearerRequestAuthenticationResultBuilder(accessToken);
        return builder.build();
    }
}

