/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.ds.DataStore;
import com.stormpath.sdk.impl.http.HttpHeaders;
import com.stormpath.sdk.impl.http.MediaType;
import com.stormpath.sdk.impl.oauth.AbstractOAuthRequestAuthenticator;
import com.stormpath.sdk.impl.oauth.DefaultOAuthGrantRequestAuthenticationResultBuilder;
import com.stormpath.sdk.impl.oauth.DefaultOAuthPasswordGrantAuthenticationAttempt;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.GrantAuthenticationToken;
import com.stormpath.sdk.oauth.OAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthRequestAuthentication;

public class DefaultOAuthPasswordGrantRequestAuthenticator
extends AbstractOAuthRequestAuthenticator
implements OAuthPasswordGrantRequestAuthenticator {
    static final String OAUTH_TOKEN_PATH = "/oauth/token";

    public DefaultOAuthPasswordGrantRequestAuthenticator(Application application, DataStore dataStore) {
        super(application, dataStore);
    }

    public OAuthGrantRequestAuthenticationResult authenticate(OAuthRequestAuthentication authenticationRequest) {
        Assert.notNull((Object)this.application, (String)"application cannot be null or empty");
        Assert.isInstanceOf(OAuthPasswordGrantRequestAuthentication.class, (Object)authenticationRequest, (String)"authenticationRequest must be an instance of PasswordGrantRequest.");
        OAuthPasswordGrantRequestAuthentication oauthPasswordGrantRequestAuthentication = (OAuthPasswordGrantRequestAuthentication)authenticationRequest;
        DefaultOAuthPasswordGrantAuthenticationAttempt oauthPasswordGrantAuthenticationAttempt = new DefaultOAuthPasswordGrantAuthenticationAttempt(this.dataStore);
        oauthPasswordGrantAuthenticationAttempt.setLogin(oauthPasswordGrantRequestAuthentication.getLogin());
        oauthPasswordGrantAuthenticationAttempt.setPassword(oauthPasswordGrantRequestAuthentication.getPassword());
        oauthPasswordGrantAuthenticationAttempt.setGrantType(oauthPasswordGrantRequestAuthentication.getGrantType());
        if (oauthPasswordGrantRequestAuthentication.getAccountStore() != null) {
            oauthPasswordGrantAuthenticationAttempt.setAccountStore(oauthPasswordGrantRequestAuthentication.getAccountStore());
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        GrantAuthenticationToken grantResult = this.dataStore.create(this.application.getHref() + OAUTH_TOKEN_PATH, oauthPasswordGrantAuthenticationAttempt, GrantAuthenticationToken.class, httpHeaders);
        DefaultOAuthGrantRequestAuthenticationResultBuilder builder = new DefaultOAuthGrantRequestAuthenticationResultBuilder(grantResult);
        return builder.build();
    }
}

