/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.ds.DataStore;
import com.stormpath.sdk.impl.http.HttpHeaders;
import com.stormpath.sdk.impl.http.MediaType;
import com.stormpath.sdk.impl.oauth.AbstractOAuthRequestAuthenticator;
import com.stormpath.sdk.impl.oauth.DefaultOAuthGrantRequestAuthenticationResultBuilder;
import com.stormpath.sdk.impl.oauth.DefaultRefreshAuthenticationAttempt;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.GrantAuthenticationToken;
import com.stormpath.sdk.oauth.OAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthRefreshTokenRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthRequestAuthentication;

public class DefaultOAuthRefreshTokenRequestAuthenticator
extends AbstractOAuthRequestAuthenticator
implements OAuthRefreshTokenRequestAuthenticator {
    static final String OAUTH_TOKEN_PATH = "/oauth/token";

    public DefaultOAuthRefreshTokenRequestAuthenticator(Application application, DataStore dataStore) {
        super(application, dataStore);
    }

    public OAuthGrantRequestAuthenticationResult authenticate(OAuthRequestAuthentication authenticationRequest) {
        Assert.notNull((Object)this.application, (String)"application cannot be null or empty");
        Assert.isInstanceOf(OAuthRefreshTokenRequestAuthentication.class, (Object)authenticationRequest, (String)"authenticationRequest must be an instance of RefreshGrantRequest.");
        OAuthRefreshTokenRequestAuthentication refreshGrantRequest = (OAuthRefreshTokenRequestAuthentication)authenticationRequest;
        DefaultRefreshAuthenticationAttempt attempt = new DefaultRefreshAuthenticationAttempt(this.dataStore);
        attempt.setRefreshToken(refreshGrantRequest.getRefreshToken());
        attempt.setGrantType(refreshGrantRequest.getGrantType());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        GrantAuthenticationToken grantResult = this.dataStore.create(this.application.getHref() + OAUTH_TOKEN_PATH, attempt, GrantAuthenticationToken.class, httpHeaders);
        DefaultOAuthGrantRequestAuthenticationResultBuilder builder = new DefaultOAuthGrantRequestAuthenticationResultBuilder(grantResult);
        return builder.setIsRefreshAuthGrantRequest(true).build();
    }
}

