/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.organization;

import com.stormpath.sdk.impl.organization.CreateOrganizationAndDirectoryRequest;
import com.stormpath.sdk.impl.organization.DefaultCreateOrganizationRequest;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.organization.CreateOrganizationRequest;
import com.stormpath.sdk.organization.CreateOrganizationRequestBuilder;
import com.stormpath.sdk.organization.Organization;

public class DefaultCreateOrganizationRequestBuilder
implements CreateOrganizationRequestBuilder {
    private Organization organization;
    private boolean createDirectory;
    private String directoryName;

    public DefaultCreateOrganizationRequestBuilder(Organization organization) {
        Assert.notNull((Object)organization, (String)"organization cannot be null.");
        this.organization = organization;
    }

    public CreateOrganizationRequest build() {
        if (this.createDirectory) {
            return new CreateOrganizationAndDirectoryRequest(this.organization, this.directoryName);
        }
        return new DefaultCreateOrganizationRequest(this.organization);
    }

    public CreateOrganizationRequestBuilder createDirectory() {
        this.createDirectory = true;
        return this;
    }

    public CreateOrganizationRequestBuilder createDirectoryNamed(String directoryName) {
        if (directoryName != null) {
            this.createDirectory = true;
        }
        this.directoryName = directoryName;
        return this;
    }
}

