/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.provider;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.provider.CreateProviderRequest;
import com.stormpath.sdk.provider.CreateProviderRequestBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class AbstractCreateProviderRequestBuilder<T extends CreateProviderRequestBuilder<T>>
implements CreateProviderRequestBuilder<T> {
    protected String clientId;
    protected String clientSecret;

    AbstractCreateProviderRequestBuilder() {
    }

    public T setClientId(String clientId) {
        this.clientId = clientId;
        return (T)this;
    }

    public T setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return (T)this;
    }

    public CreateProviderRequest build() {
        Assert.state((boolean)Strings.hasText((String)this.clientId), (String)"clientId is a required property. It must be provided before building.");
        Assert.state((boolean)Strings.hasText((String)this.clientSecret), (String)"clientSecret is a required property. It must be provided before building.");
        String providerId = this.getConcreteProviderId();
        Assert.state((boolean)Strings.hasText((String)providerId), (String)"The providerId property is missing.");
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("providerId", providerId);
        return this.doBuild(Collections.unmodifiableMap(properties));
    }

    protected abstract String getConcreteProviderId();

    protected abstract CreateProviderRequest doBuild(Map<String, Object> var1);
}

