/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.provider;

import com.stormpath.sdk.impl.provider.DefaultCreateProviderRequest;
import com.stormpath.sdk.impl.provider.DefaultSamlProvider;
import com.stormpath.sdk.impl.provider.IdentityProviderType;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.provider.CreateProviderRequest;
import com.stormpath.sdk.provider.saml.CreateSamlProviderRequestBuilder;
import com.stormpath.sdk.saml.AttributeStatementMappingRules;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultCreateSamlProviderRequestBuilder
implements CreateSamlProviderRequestBuilder {
    private String ssoLoginUrl;
    private String ssoLogoutUrl;
    private String encodedX509SigningCert;
    private String requestSignatureAlgorithm;
    private AttributeStatementMappingRules attributeStatementMappingRules;

    protected String getConcreteProviderId() {
        return IdentityProviderType.SAML.getNameKey();
    }

    public CreateSamlProviderRequestBuilder setSsoLoginUrl(String ssoLoginUrl) {
        Assert.notNull((Object)ssoLoginUrl, (String)"ssoLoginUrl cannot be null or empty.");
        this.ssoLoginUrl = ssoLoginUrl;
        return this;
    }

    public CreateSamlProviderRequestBuilder setSsoLogoutUrl(String ssoLogoutUrl) {
        Assert.notNull((Object)ssoLogoutUrl, (String)"ssoLogoutUrl cannot be null or empty.");
        this.ssoLogoutUrl = ssoLogoutUrl;
        return this;
    }

    public CreateSamlProviderRequestBuilder setRequestSignatureAlgorithm(String requestSignatureAlgorithm) {
        Assert.notNull((Object)requestSignatureAlgorithm, (String)"requestSignatureAlgorithm cannot be null or empty.");
        this.requestSignatureAlgorithm = requestSignatureAlgorithm;
        return this;
    }

    public CreateSamlProviderRequestBuilder setEncodedX509SigningCert(String encodedX509SigningCert) {
        Assert.notNull((Object)encodedX509SigningCert, (String)"encodedX509SigningCert cannot be null or empty.");
        this.encodedX509SigningCert = encodedX509SigningCert;
        return this;
    }

    public CreateSamlProviderRequestBuilder setAttributeStatementMappingRules(AttributeStatementMappingRules attributeStatementMappingRules) {
        Assert.notNull((Object)attributeStatementMappingRules, (String)"attributeStatementMappingRules cannot be null or empty.");
        this.attributeStatementMappingRules = attributeStatementMappingRules;
        return this;
    }

    protected CreateProviderRequest doBuild(Map<String, Object> map) {
        DefaultSamlProvider provider = new DefaultSamlProvider(null, map);
        provider.setEncodedX509SigningCert(this.encodedX509SigningCert);
        provider.setRequestSignatureAlgorithm(this.requestSignatureAlgorithm);
        provider.setSsoLoginUrl(this.ssoLoginUrl);
        provider.setSsoLogoutUrl(this.ssoLogoutUrl);
        if (this.attributeStatementMappingRules != null) {
            provider.setAttributeStatementMappingRules(this.attributeStatementMappingRules);
        }
        return new DefaultCreateProviderRequest(provider);
    }

    public CreateProviderRequest build() {
        String providerId = this.getConcreteProviderId();
        Assert.state((boolean)Strings.hasText((String)providerId), (String)"The providerId property is missing.");
        Assert.state((boolean)Strings.hasText((String)this.encodedX509SigningCert), (String)"The encodedX509SigningCert property is missing.");
        Assert.state((boolean)Strings.hasText((String)this.requestSignatureAlgorithm), (String)"The requestSignatureAlgorithm property is missing.");
        Assert.state((boolean)Strings.hasText((String)this.ssoLoginUrl), (String)"The ssoLoginUrl property is missing.");
        Assert.state((boolean)Strings.hasText((String)this.ssoLogoutUrl), (String)"The ssoLogoutUrl property is missing.");
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("providerId", providerId);
        return this.doBuild(Collections.unmodifiableMap(properties));
    }
}

