/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.query;

import com.stormpath.sdk.impl.query.CollectionExpansion;
import com.stormpath.sdk.impl.query.Expandable;
import com.stormpath.sdk.impl.query.Expansion;
import com.stormpath.sdk.impl.query.Pagination;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.query.Options;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultOptions<T extends Options>
implements Options,
Expandable {
    protected final List<Expansion> expansions = new ArrayList<Expansion>();

    protected DefaultOptions() {
    }

    protected T expand(ResourceReference property) {
        Assert.notNull((Object)property, (String)"property argument cannot be null.");
        this.expansions.add(new Expansion(property.getName()));
        return (T)this;
    }

    protected T expand(CollectionReference property, int limit) {
        return this.expand(property, limit, Pagination.DEFAULT_OFFSET.getValue());
    }

    protected T expand(CollectionReference property, int limit, int offset) {
        Assert.notNull((Object)property, (String)"property argument cannot be null.");
        int sLimit = Pagination.sanitizeLimit(limit);
        int sOffset = Pagination.sanitizeOffset(offset);
        this.expansions.add(new CollectionExpansion(property.getName(), sLimit, sOffset));
        return (T)this;
    }

    @Override
    public List<Expansion> getExpansions() {
        return Collections.unmodifiableList(this.expansions);
    }

    public boolean isEmpty() {
        return this.expansions.isEmpty();
    }
}

