/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.query;

public enum Pagination {
    DEFAULT_LIMIT(25),
    DEFAULT_OFFSET(0),
    MAX_LIMIT(100),
    MIN_LIMIT(1);

    private int value;

    private Pagination(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    static int sanitizeLimit(int limit) {
        limit = Math.min(limit, MAX_LIMIT.getValue());
        limit = Math.max(limit, MIN_LIMIT.getValue());
        return limit;
    }

    static int sanitizeOffset(int offset) {
        offset = Math.min(offset, Integer.MAX_VALUE);
        offset = Math.max(offset, DEFAULT_OFFSET.getValue());
        return offset;
    }
}

